/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.rds.RDSApi;
import org.jclouds.rds.RDSAsyncApi;
import org.jclouds.rds.config.RDSRestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class RDSApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = -7077953935392202824L;
    public static final TypeToken<RestContext<RDSApi, RDSAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<RDSApi, RDSAsyncApi>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata((ApiMetadata)this);
    }

    public RDSApiMetadata() {
        this(new Builder(RDSApi.class, RDSAsyncApi.class));
    }

    protected RDSApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> api, Class<?> asyncApi) {
            super(api, asyncApi);
            this.id("rds").name("Amazon Relational Database Service Api").identityName("Access Key ID").credentialName("Secret Access Key").version("2012-04-23").defaultProperties(RDSApiMetadata.defaultProperties()).defaultEndpoint("https://rds.us-east-1.amazonaws.com").documentation(URI.create("http://docs.amazonwebservices.com/AmazonRDS/latest/APIReference")).defaultModules((Set)ImmutableSet.of(RDSRestClientModule.class));
        }

        public RDSApiMetadata build() {
            return new RDSApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

