/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.http.HttpRequest;
import org.jclouds.rds.domain.InstanceRequest;
import org.jclouds.rest.Binder;

public class BindInstanceRequestToFormParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        InstanceRequest instanceRequest = (InstanceRequest)InstanceRequest.class.cast(Preconditions.checkNotNull((Object)input, (Object)"instanceRequest must be set!"));
        ImmutableMultimap.Builder formParameters = ImmutableMultimap.builder();
        formParameters.put((Object)"AllocatedStorage", (Object)(instanceRequest.getAllocatedStorageGB() + ""));
        formParameters.put((Object)"AutoMinorVersionUpgrade", (Object)(instanceRequest.isAutoMinorVersionUpgrade() + ""));
        formParameters.put((Object)"BackupRetentionPeriod", (Object)(instanceRequest.getBackupRetentionPeriod() + ""));
        if (instanceRequest.getCharacterSet().isPresent()) {
            formParameters.put((Object)"CharacterSetName", instanceRequest.getCharacterSet().get());
        }
        formParameters.put((Object)"DBInstanceClass", (Object)instanceRequest.getInstanceClass());
        if (instanceRequest.getName().isPresent()) {
            formParameters.put((Object)"DBName", instanceRequest.getName().get());
        }
        if (instanceRequest.getParameterGroup().isPresent()) {
            formParameters.put((Object)"DBParameterGroupName", instanceRequest.getParameterGroup().get());
        }
        int groupIndex = 1;
        for (String securityGroup : instanceRequest.getSecurityGroups()) {
            formParameters.put((Object)("DBSecurityGroups.member." + groupIndex++), (Object)securityGroup);
        }
        if (instanceRequest.getSubnetGroup().isPresent()) {
            formParameters.put((Object)"DBSubnetGroupName", instanceRequest.getSubnetGroup().get());
        }
        formParameters.put((Object)"Engine", (Object)instanceRequest.getEngine());
        if (instanceRequest.getEngineVersion().isPresent()) {
            formParameters.put((Object)"EngineVersion", instanceRequest.getEngineVersion().get());
        }
        if (instanceRequest.getLicenseModel().isPresent()) {
            formParameters.put((Object)"LicenseModel", instanceRequest.getLicenseModel().get());
        }
        formParameters.put((Object)"MasterUserPassword", (Object)instanceRequest.getMasterPassword());
        formParameters.put((Object)"MasterUsername", (Object)instanceRequest.getMasterUsername());
        if (instanceRequest.getOptionGroup().isPresent()) {
            formParameters.put((Object)"OptionGroupName", instanceRequest.getOptionGroup().get());
        }
        if (instanceRequest.getPort().isPresent()) {
            formParameters.put((Object)"Port", (Object)((Integer)instanceRequest.getPort().get()).toString());
        }
        return (R)request.toBuilder().replaceFormParams((Multimap)formParameters.build()).build();
    }
}

