/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class Authorization {
    protected final String rawStatus;
    protected final Status status;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAuthorization(this);
    }

    protected Authorization(String rawStatus, Status status) {
        this.rawStatus = (String)Preconditions.checkNotNull((Object)rawStatus, (Object)"rawStatus");
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
    }

    public Status getStatus() {
        return this.status;
    }

    public String getRawStatus() {
        return this.rawStatus;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rawStatus});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Authorization other = (Authorization)obj;
        return Objects.equal((Object)this.rawStatus, (Object)other.rawStatus);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("status", (Object)this.rawStatus).toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String rawStatus;
        protected Status status;

        protected abstract T self();

        public T rawStatus(String rawStatus) {
            this.rawStatus = rawStatus;
            return this.self();
        }

        public T status(Status status) {
            this.status = status;
            return this.self();
        }

        public T fromAuthorization(Authorization in) {
            return ((Builder)this.rawStatus(in.getRawStatus())).status(in.getStatus());
        }
    }

    public static enum Status {
        AUTHORIZING,
        AUTHORIZED,
        REVOKING,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)status, (Object)"status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

