/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.rds.domain.Authorization;

public class EC2SecurityGroup
extends Authorization {
    protected final Optional<String> id;
    protected final String name;
    protected final String ownerId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromEC2SecurityGroup(this);
    }

    protected EC2SecurityGroup(Optional<String> id, String name, String ownerId, String rawStatus, Authorization.Status status) {
        super(rawStatus, status);
        this.id = (Optional)Preconditions.checkNotNull(id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.ownerId = (String)Preconditions.checkNotNull((Object)ownerId, (Object)"ownerId");
    }

    public Optional<String> getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.ownerId});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EC2SecurityGroup other = (EC2SecurityGroup)EC2SecurityGroup.class.cast(obj);
        return Objects.equal(this.id, other.id) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.ownerId, (Object)other.ownerId);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", this.id.orNull()).add("name", (Object)this.name).add("ownerId", (Object)this.ownerId).add("status", (Object)this.rawStatus).toString();
    }

    public static class Builder
    extends Authorization.Builder<Builder> {
        protected Optional<String> id = Optional.absent();
        protected String name;
        protected String ownerId;

        public Builder id(String id) {
            this.id = Optional.fromNullable((Object)id);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public EC2SecurityGroup build() {
            return new EC2SecurityGroup(this.id, this.name, this.ownerId, this.rawStatus, this.status);
        }

        public Builder fromEC2SecurityGroup(EC2SecurityGroup in) {
            return ((Builder)this.fromAuthorization(in)).id((String)in.getId().orNull()).name(in.getName()).ownerId(in.getOwnerId());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

