/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.rds.domain.Authorization;

public class IPRange
extends Authorization {
    protected final String cidrIp;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromIPRange(this);
    }

    protected IPRange(String cidrIp, String rawStatus, Authorization.Status status) {
        super(rawStatus, status);
        this.cidrIp = (String)Preconditions.checkNotNull((Object)cidrIp, (Object)"cidrIp");
    }

    public String getCIDRIP() {
        return this.cidrIp;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cidrIp, this.rawStatus});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPRange other = (IPRange)IPRange.class.cast(obj);
        return Objects.equal((Object)this.cidrIp, (Object)other.cidrIp) && Objects.equal((Object)this.rawStatus, (Object)other.rawStatus);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("cidrIp", (Object)this.cidrIp).add("status", (Object)this.rawStatus).toString();
    }

    public static class Builder
    extends Authorization.Builder<Builder> {
        protected String cidrIp;

        public Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public IPRange build() {
            return new IPRange(this.cidrIp, this.rawStatus, this.status);
        }

        public Builder fromIPRange(IPRange in) {
            return ((Builder)this.fromAuthorization(in)).cidrIp(in.getCIDRIP());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

