/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.util.Date;
import java.util.Map;
import org.jclouds.rds.domain.SubnetGroup;
import org.jclouds.rds.domain.internal.BaseInstance;

public class Instance
extends BaseInstance {
    protected final String id;
    protected final Optional<HostAndPort> endpoint;
    protected final String rawStatus;
    protected final Status status;
    protected final Optional<Date> createdTime;
    protected final String engineVersion;
    protected final String licenseModel;
    protected final Optional<String> availabilityZone;
    protected final boolean multiAZ;
    protected final Optional<SubnetGroup> subnetGroup;
    protected final Map<String, String> securityGroupNameToStatus;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromInstance(this);
    }

    protected Instance(String id, Optional<String> name, String instanceClass, Optional<HostAndPort> endpoint, String rawStatus, Status status, Optional<String> availabilityZone, boolean multiAZ, String engine, String engineVersion, String licenseModel, String masterUsername, int allocatedStorageGB, Optional<Date> createdTime, Optional<SubnetGroup> subnetGroup, Map<String, String> securityGroupNameToStatus) {
        super(name, instanceClass, engine, masterUsername, allocatedStorageGB);
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.availabilityZone = (Optional)Preconditions.checkNotNull(availabilityZone, (String)"availabilityZone of %s", (Object[])new Object[]{id});
        this.multiAZ = multiAZ;
        this.endpoint = (Optional)Preconditions.checkNotNull(endpoint, (String)"endpoint of %s", (Object[])new Object[]{id});
        this.rawStatus = (String)Preconditions.checkNotNull((Object)rawStatus, (String)"rawStatus of %s", (Object[])new Object[]{id});
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (String)"status of %s", (Object[])new Object[]{id}));
        this.engineVersion = (String)Preconditions.checkNotNull((Object)engineVersion, (String)"engineVersion of %s", (Object[])new Object[]{id});
        this.licenseModel = (String)Preconditions.checkNotNull((Object)licenseModel, (String)"licenseModel of %s", (Object[])new Object[]{id});
        this.createdTime = (Optional)Preconditions.checkNotNull(createdTime, (String)"createdTime of %s", (Object[])new Object[]{id});
        this.subnetGroup = (Optional)Preconditions.checkNotNull(subnetGroup, (String)"subnetGroup of %s", (Object[])new Object[]{id});
        this.securityGroupNameToStatus = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(securityGroupNameToStatus, (String)"securityGroupNameToStatus of %s", (Object[])new Object[]{id})));
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getRawStatus() {
        return this.rawStatus;
    }

    public Optional<HostAndPort> getEndpoint() {
        return this.endpoint;
    }

    public Optional<Date> getCreatedTime() {
        return this.createdTime;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public Optional<String> getAvailabilityZone() {
        return this.availabilityZone;
    }

    public boolean isMultiAZ() {
        return this.multiAZ;
    }

    public Optional<SubnetGroup> getSubnetGroup() {
        return this.subnetGroup;
    }

    public Map<String, String> getSecurityGroupNameToStatus() {
        return this.securityGroupNameToStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Instance that = (Instance)Instance.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", this.name.orNull()).add("instanceClass", (Object)this.instanceClass).add("endpoint", this.endpoint.orNull()).add("status", (Object)this.rawStatus).add("availabilityZone", this.availabilityZone.orNull()).add("multiAZ", this.multiAZ).add("engine", (Object)this.engine).add("engineVersion", (Object)this.engineVersion).add("licenseModel", (Object)this.licenseModel).add("masterUsername", (Object)this.masterUsername).add("allocatedStorageGB", this.allocatedStorageGB).add("createdTime", this.createdTime.orNull()).add("subnetGroup", this.subnetGroup.orNull()).add("securityGroupNameToStatus", this.securityGroupNameToStatus).toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseInstance.Builder<T> {
        protected String id;
        protected Optional<HostAndPort> endpoint = Optional.absent();
        protected String engineVersion;
        protected String rawStatus;
        protected Status status;
        protected Optional<Date> createdTime = Optional.absent();
        protected String licenseModel;
        protected Optional<String> availabilityZone = Optional.absent();
        protected boolean multiAZ;
        protected Optional<SubnetGroup> subnetGroup = Optional.absent();
        protected ImmutableMap.Builder<String, String> securityGroupNameToStatus = ImmutableMap.builder();

        public T id(String id) {
            this.id = id;
            return (T)((Builder)this.self());
        }

        public T endpoint(HostAndPort endpoint) {
            this.endpoint = Optional.fromNullable((Object)endpoint);
            return (T)((Builder)this.self());
        }

        public T rawStatus(String rawStatus) {
            this.rawStatus = rawStatus;
            return (T)((Builder)this.self());
        }

        public T status(Status status) {
            this.status = status;
            return (T)((Builder)this.self());
        }

        public T engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return (T)((Builder)this.self());
        }

        public T licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return (T)((Builder)this.self());
        }

        public T createdTime(Date createdTime) {
            this.createdTime = Optional.fromNullable((Object)createdTime);
            return (T)((Builder)this.self());
        }

        public T availabilityZone(String availabilityZone) {
            this.availabilityZone = Optional.fromNullable((Object)availabilityZone);
            return (T)((Builder)this.self());
        }

        public T multiAZ(boolean multiAZ) {
            this.multiAZ = multiAZ;
            return (T)((Builder)this.self());
        }

        public T subnetGroup(SubnetGroup subnetGroup) {
            this.subnetGroup = Optional.fromNullable((Object)subnetGroup);
            return (T)((Builder)this.self());
        }

        public T securityGroupNameToStatus(Map<String, String> securityGroupNameToStatus) {
            this.securityGroupNameToStatus.putAll((Map)Preconditions.checkNotNull(securityGroupNameToStatus, (Object)"securityGroupNameToStatus"));
            return (T)((Builder)this.self());
        }

        public T securityGroupNameToStatus(String securityGroupName, String status) {
            this.securityGroupNameToStatus.put(Preconditions.checkNotNull((Object)securityGroupName, (Object)"securityGroupName"), Preconditions.checkNotNull((Object)status, (Object)"status"));
            return (T)((Builder)this.self());
        }

        @Override
        public Instance build() {
            return new Instance(this.id, (Optional<String>)this.name, this.instanceClass, this.endpoint, this.rawStatus, this.status, this.availabilityZone, this.multiAZ, this.engine, this.engineVersion, this.licenseModel, this.masterUsername, this.allocatedStorageGB, this.createdTime, this.subnetGroup, (Map<String, String>)this.securityGroupNameToStatus.build());
        }

        public T fromInstance(Instance in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.fromBaseInstance(in)).id(in.getId())).endpoint((HostAndPort)in.getEndpoint().orNull())).status(in.getStatus())).createdTime((Date)in.getCreatedTime().orNull())).engineVersion(in.getEngineVersion())).licenseModel(in.getLicenseModel())).availabilityZone((String)in.getAvailabilityZone().orNull())).multiAZ(in.isMultiAZ())).subnetGroup((SubnetGroup)in.getSubnetGroup().orNull())).securityGroupNameToStatus(in.getSecurityGroupNameToStatus());
        }
    }

    public static enum Status {
        CREATING,
        AVAILABLE,
        STORAGE_FULL,
        INCOMPATIBLE_OPTION_GROUP,
        INCOMPATIBLE_PARAMETERS,
        INCOMPATIBLE_RESTORE,
        FAILED,
        DELETING,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)status, (Object)"status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

