/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.rds.domain.internal.BaseInstance;

public class InstanceRequest
extends BaseInstance {
    protected final Optional<String> engineVersion;
    protected final Optional<String> licenseModel;
    protected final Optional<Integer> port;
    protected final Optional<String> characterSet;
    protected final int backupRetentionPeriod;
    protected final Optional<String> optionGroup;
    protected final Optional<String> parameterGroup;
    protected final boolean autoMinorVersionUpgrade;
    protected final Optional<String> subnetGroup;
    protected final Set<String> securityGroups;
    protected final String masterPassword;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromInstance(this);
    }

    protected InstanceRequest(Optional<String> name, String instanceClass, Optional<Integer> port, Optional<String> characterSet, Optional<String> optionGroup, Optional<String> parameterGroup, boolean autoMinorVersionUpgrade, String engine, Optional<String> engineVersion, Optional<String> licenseModel, String masterUsername, int allocatedStorageGB, int backupRetentionPeriod, Optional<String> subnetGroup, Iterable<String> securityGroups, String masterPassword) {
        super(name, instanceClass, engine, masterUsername, allocatedStorageGB);
        this.engineVersion = (Optional)Preconditions.checkNotNull(engineVersion, (Object)"engineVersion");
        this.licenseModel = (Optional)Preconditions.checkNotNull(licenseModel, (Object)"licenseModel");
        this.optionGroup = (Optional)Preconditions.checkNotNull(optionGroup, (Object)"optionGroup");
        this.parameterGroup = (Optional)Preconditions.checkNotNull(parameterGroup, (Object)"parameterGroup");
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        this.port = (Optional)Preconditions.checkNotNull(port, (Object)"port");
        this.characterSet = (Optional)Preconditions.checkNotNull(characterSet, (Object)"characterSet");
        this.backupRetentionPeriod = (Integer)Preconditions.checkNotNull((Object)backupRetentionPeriod, (Object)"backupRetentionPeriod");
        this.subnetGroup = (Optional)Preconditions.checkNotNull(subnetGroup, (Object)"subnetGroup");
        this.securityGroups = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(securityGroups, (Object)"securityGroups")));
        this.masterPassword = (String)Preconditions.checkNotNull((Object)masterPassword, (Object)"masterPassword");
    }

    public Optional<String> getEngineVersion() {
        return this.engineVersion;
    }

    public Optional<String> getLicenseModel() {
        return this.licenseModel;
    }

    public Optional<String> getCharacterSet() {
        return this.characterSet;
    }

    public Optional<Integer> getPort() {
        return this.port;
    }

    public int getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public Optional<String> getOptionGroup() {
        return this.optionGroup;
    }

    public Optional<String> getParameterGroup() {
        return this.parameterGroup;
    }

    public boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Optional<String> getSubnetGroup() {
        return this.subnetGroup;
    }

    public Set<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("engineVersion", this.engineVersion.orNull()).add("licenseModel", this.licenseModel.orNull()).add("port", this.port.orNull()).add("characterSet", this.characterSet.orNull()).add("optionGroup", this.optionGroup).add("parameterGroup", this.parameterGroup).add("autoMinorVersionUpgrade", this.autoMinorVersionUpgrade).add("backupRetentionPeriod", this.backupRetentionPeriod).add("subnetGroup", this.subnetGroup.orNull()).add("securityGroups", this.securityGroups);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseInstance.Builder<T> {
        protected Optional<String> engineVersion = Optional.absent();
        protected Optional<String> licenseModel = Optional.absent();
        protected Optional<Integer> port = Optional.absent();
        protected Optional<String> characterSet = Optional.absent();
        protected int backupRetentionPeriod = 1;
        protected Optional<String> optionGroup = Optional.absent();
        protected Optional<String> parameterGroup = Optional.absent();
        protected boolean autoMinorVersionUpgrade = true;
        protected Optional<String> subnetGroup = Optional.absent();
        protected ImmutableSet.Builder<String> securityGroups = ImmutableSet.builder();
        protected String masterPassword;

        public T engineVersion(String engineVersion) {
            this.engineVersion = Optional.fromNullable((Object)engineVersion);
            return (T)((Builder)this.self());
        }

        public T licenseModel(String licenseModel) {
            this.licenseModel = Optional.fromNullable((Object)licenseModel);
            return (T)((Builder)this.self());
        }

        public T port(Integer port) {
            this.port = Optional.fromNullable((Object)port);
            return (T)((Builder)this.self());
        }

        public T characterSet(String characterSet) {
            this.characterSet = Optional.fromNullable((Object)characterSet);
            return (T)((Builder)this.self());
        }

        public T backupRetentionPeriod(int backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return (T)((Builder)this.self());
        }

        public T optionGroup(String optionGroup) {
            this.optionGroup = Optional.fromNullable((Object)optionGroup);
            return (T)((Builder)this.self());
        }

        public T parameterGroup(String parameterGroup) {
            this.parameterGroup = Optional.fromNullable((Object)parameterGroup);
            return (T)((Builder)this.self());
        }

        public T autoMinorVersionUpgrade(boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return (T)((Builder)this.self());
        }

        public T subnetGroup(String subnetGroup) {
            this.subnetGroup = Optional.fromNullable((Object)subnetGroup);
            return (T)((Builder)this.self());
        }

        public T securityGroups(Iterable<String> securityGroups) {
            this.securityGroups.addAll((Iterable)Preconditions.checkNotNull(securityGroups, (Object)"securityGroups"));
            return (T)((Builder)this.self());
        }

        public T securityGroup(String securityGroupName) {
            this.securityGroups.add(Preconditions.checkNotNull((Object)securityGroupName, (Object)"securityGroupName"));
            return (T)((Builder)this.self());
        }

        public T masterPassword(String masterPassword) {
            this.masterPassword = (String)Preconditions.checkNotNull((Object)masterPassword, (Object)"masterPassword");
            return (T)((Builder)this.self());
        }

        @Override
        public InstanceRequest build() {
            return new InstanceRequest((Optional<String>)this.name, this.instanceClass, this.port, this.characterSet, this.optionGroup, this.parameterGroup, this.autoMinorVersionUpgrade, this.engine, this.engineVersion, this.licenseModel, this.masterUsername, this.allocatedStorageGB, this.backupRetentionPeriod, this.subnetGroup, (Iterable<String>)this.securityGroups.build(), this.masterPassword);
        }

        public T fromInstance(InstanceRequest in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.fromBaseInstance(in)).engineVersion((String)in.getEngineVersion().orNull())).licenseModel((String)in.getLicenseModel().orNull())).port((Integer)in.getPort().orNull())).characterSet((String)in.getCharacterSet().orNull())).backupRetentionPeriod(in.getBackupRetentionPeriod())).optionGroup((String)in.getOptionGroup().orNull())).parameterGroup((String)in.getParameterGroup().orNull())).autoMinorVersionUpgrade(in.isAutoMinorVersionUpgrade())).subnetGroup((String)in.getSubnetGroup().orNull())).securityGroups(in.getSecurityGroups());
        }
    }
}

