/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.rds.domain.EC2SecurityGroup;
import org.jclouds.rds.domain.IPRange;

public class SecurityGroup {
    protected final String name;
    protected final String description;
    protected final Set<EC2SecurityGroup> ec2SecurityGroups;
    protected final Set<IPRange> ipRanges;
    protected final String ownerId;
    protected final Optional<String> vpcId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSecurityGroup(this);
    }

    protected SecurityGroup(String name, String description, Iterable<EC2SecurityGroup> ec2SecurityGroups, Iterable<IPRange> ipRanges, String ownerId, Optional<String> vpcId) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.ownerId = (String)Preconditions.checkNotNull((Object)ownerId, (Object)"ownerId");
        this.ec2SecurityGroups = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(ec2SecurityGroups, (Object)"ec2SecurityGroups")));
        this.ipRanges = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(ipRanges, (Object)"ipRanges")));
        this.vpcId = (Optional)Preconditions.checkNotNull(vpcId, (Object)"vpcId");
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<EC2SecurityGroup> getEC2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public Set<IPRange> getIPRanges() {
        return this.ipRanges;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public Optional<String> getVpcId() {
        return this.vpcId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroup other = (SecurityGroup)obj;
        return Objects.equal((Object)this.name, (Object)other.name);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("ec2SecurityGroups", this.ec2SecurityGroups).add("ipRanges", this.ipRanges).add("ownerId", (Object)this.ownerId).add("vpcId", this.vpcId.orNull());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected String description;
        protected ImmutableSet.Builder<EC2SecurityGroup> ec2SecurityGroups = ImmutableSet.builder();
        protected ImmutableSet.Builder<IPRange> ipRanges = ImmutableSet.builder();
        protected String ownerId;
        protected Optional<String> vpcId = Optional.absent();

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T ec2SecurityGroups(Iterable<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups.addAll((Iterable)Preconditions.checkNotNull(ec2SecurityGroups, (Object)"ec2SecurityGroups"));
            return this.self();
        }

        public T ec2SecurityGroup(EC2SecurityGroup ec2SecurityGroup) {
            this.ec2SecurityGroups.add(Preconditions.checkNotNull((Object)ec2SecurityGroup, (Object)"ec2SecurityGroup"));
            return this.self();
        }

        public T ipRanges(Iterable<IPRange> ipRanges) {
            this.ipRanges.addAll((Iterable)Preconditions.checkNotNull(ipRanges, (Object)"ipRanges"));
            return this.self();
        }

        public T ipRange(IPRange ipRange) {
            this.ipRanges.add(Preconditions.checkNotNull((Object)ipRange, (Object)"ipRange"));
            return this.self();
        }

        public T ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this.self();
        }

        public T vpcId(String vpcId) {
            this.vpcId = Optional.fromNullable((Object)vpcId);
            return this.self();
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.name, this.description, (Iterable<EC2SecurityGroup>)this.ec2SecurityGroups.build(), (Iterable<IPRange>)this.ipRanges.build(), this.ownerId, this.vpcId);
        }

        public T fromSecurityGroup(SecurityGroup in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).description(in.getDescription())).ec2SecurityGroups(in.getEC2SecurityGroups())).ipRanges(in.getIPRanges())).ownerId(in.getOwnerId())).vpcId((String)in.getVpcId().orNull());
        }
    }
}

