/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class Subnet {
    protected final String id;
    protected final String availabilityZone;
    protected final String status;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromSubnet(this);
    }

    protected Subnet(String id, String availabilityZone, String status) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.availabilityZone = (String)Preconditions.checkNotNull((Object)availabilityZone, (Object)"availabilityZone");
        this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status");
    }

    public String getId() {
        return this.id;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subnet other = (Subnet)Subnet.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)other.id);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("availabilityZone", (Object)this.availabilityZone).add("status", (Object)this.status).toString();
    }

    public static class Builder {
        protected String id;
        protected String availabilityZone;
        protected String status;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Subnet build() {
            return new Subnet(this.id, this.availabilityZone, this.status);
        }

        public Builder fromSubnet(Subnet in) {
            return this.id(in.getId()).availabilityZone(in.getAvailabilityZone()).status(in.getStatus());
        }
    }
}

