/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.rds.domain.Subnet;

public class SubnetGroup {
    protected final String name;
    protected final String description;
    protected final String status;
    protected final Set<Subnet> subnets;
    protected final Optional<String> vpcId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSubnetGroup(this);
    }

    protected SubnetGroup(String name, String description, String status, Iterable<Subnet> subnets, Optional<String> vpcId) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status");
        this.subnets = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(subnets, (Object)"subnets")));
        this.vpcId = (Optional)Preconditions.checkNotNull(vpcId, (Object)"vpcId");
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStatus() {
        return this.status;
    }

    public Set<Subnet> getSubnets() {
        return this.subnets;
    }

    public Optional<String> getVpcId() {
        return this.vpcId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.vpcId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubnetGroup other = (SubnetGroup)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.vpcId, other.vpcId);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("status", (Object)this.status).add("subnets", this.subnets).add("vpcId", this.vpcId.orNull());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected String description;
        protected String status;
        protected ImmutableSet.Builder<Subnet> subnets = ImmutableSet.builder();
        protected Optional<String> vpcId = Optional.absent();

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T status(String status) {
            this.status = status;
            return this.self();
        }

        public T subnets(Iterable<Subnet> subnets) {
            this.subnets.addAll((Iterable)Preconditions.checkNotNull(subnets, (Object)"subnets"));
            return this.self();
        }

        public T subnet(Subnet subnet) {
            this.subnets.add(Preconditions.checkNotNull((Object)subnet, (Object)"subnet"));
            return this.self();
        }

        public T vpcId(String vpcId) {
            this.vpcId = Optional.fromNullable((Object)vpcId);
            return this.self();
        }

        public SubnetGroup build() {
            return new SubnetGroup(this.name, this.description, this.status, (Iterable<Subnet>)this.subnets.build(), this.vpcId);
        }

        public T fromSubnetGroup(SubnetGroup in) {
            return ((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).description(in.getDescription())).status(in.getStatus())).subnets(in.getSubnets())).vpcId((String)in.getVpcId().orNull());
        }
    }
}

