/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class BaseInstance {
    protected final Optional<String> name;
    protected final String instanceClass;
    protected final String engine;
    protected final String masterUsername;
    protected int allocatedStorageGB;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromBaseInstance(this);
    }

    protected BaseInstance(Optional<String> name, String instanceClass, String engine, String masterUsername, int allocatedStorageGB) {
        this.name = (Optional)Preconditions.checkNotNull(name, (Object)"name");
        this.instanceClass = (String)Preconditions.checkNotNull((Object)instanceClass, (Object)"instanceClass");
        this.engine = (String)Preconditions.checkNotNull((Object)engine, (Object)"engine");
        this.masterUsername = (String)Preconditions.checkNotNull((Object)masterUsername, (Object)"masterUsername");
        this.allocatedStorageGB = allocatedStorageGB;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public int getAllocatedStorageGB() {
        return this.allocatedStorageGB;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name.orNull(), this.instanceClass, this.engine, this.masterUsername, this.allocatedStorageGB});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseInstance other = (BaseInstance)obj;
        return Objects.equal(this.name, other.name) && Objects.equal((Object)this.instanceClass, (Object)other.instanceClass) && Objects.equal((Object)this.engine, (Object)other.engine) && Objects.equal((Object)this.masterUsername, (Object)other.masterUsername) && Objects.equal((Object)this.allocatedStorageGB, (Object)other.allocatedStorageGB);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", this.name.orNull()).add("instanceClass", (Object)this.instanceClass).add("engine", (Object)this.engine).add("masterUsername", (Object)this.masterUsername).add("allocatedStorageGB", this.allocatedStorageGB);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Optional<String> name = Optional.absent();
        protected String instanceClass;
        protected String engine;
        protected String masterUsername;
        protected int allocatedStorageGB;

        protected abstract T self();

        public T name(String name) {
            this.name = Optional.fromNullable((Object)name);
            return this.self();
        }

        public T instanceClass(String instanceClass) {
            this.instanceClass = instanceClass;
            return this.self();
        }

        public T engine(String engine) {
            this.engine = engine;
            return this.self();
        }

        public T masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this.self();
        }

        public T allocatedStorageGB(int allocatedStorageGB) {
            this.allocatedStorageGB = allocatedStorageGB;
            return this.self();
        }

        public BaseInstance build() {
            return new BaseInstance(this.name, this.instanceClass, this.engine, this.masterUsername, this.allocatedStorageGB);
        }

        public T fromBaseInstance(BaseInstance in) {
            return ((Builder)((Builder)((Builder)((Builder)this.name((String)in.getName().orNull())).instanceClass(in.getInstanceClass())).engine(in.getEngine())).masterUsername(in.getMasterUsername())).allocatedStorageGB(in.getAllocatedStorageGB());
        }
    }
}

