/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.rds.binders.BindInstanceRequestToFormParams;
import org.jclouds.rds.domain.Instance;
import org.jclouds.rds.domain.InstanceRequest;
import org.jclouds.rds.functions.InstancesToPagedIterable;
import org.jclouds.rds.functions.ReturnNullOnStateDeletingNotFoundOr404;
import org.jclouds.rds.options.ListInstancesOptions;
import org.jclouds.rds.xml.DescribeDBInstancesResultHandler;
import org.jclouds.rds.xml.InstanceHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface InstanceAsyncApi {
    @Named(value="rds:CreateDBInstance")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=InstanceHandler.class)
    @FormParams(keys={"Action"}, values={"CreateDBInstance"})
    public ListenableFuture<Instance> create(@FormParam(value="DBInstanceIdentifier") String var1, @BinderParam(value=BindInstanceRequestToFormParams.class) InstanceRequest var2);

    @Named(value="rds:CreateDBInstance")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=InstanceHandler.class)
    @FormParams(keys={"Action"}, values={"CreateDBInstance"})
    public ListenableFuture<Instance> createInAvailabilityZone(@FormParam(value="DBInstanceIdentifier") String var1, @BinderParam(value=BindInstanceRequestToFormParams.class) InstanceRequest var2, @FormParam(value="AvailabilityZone") String var3);

    @Named(value="rds:CreateDBInstance")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=InstanceHandler.class)
    @FormParams(keys={"Action", "MultiAZ"}, values={"CreateDBInstance", "true"})
    public ListenableFuture<Instance> createMultiAZ(@FormParam(value="DBInstanceIdentifier") String var1, @BinderParam(value=BindInstanceRequestToFormParams.class) InstanceRequest var2);

    @Named(value="rds:DescribeDBInstances")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=InstanceHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeDBInstances"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Instance> get(@FormParam(value="DBInstanceIdentifier") String var1);

    @Named(value="rds:DescribeDBInstances")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=DescribeDBInstancesResultHandler.class)
    @Transform(value=InstancesToPagedIterable.class)
    @FormParams(keys={"Action"}, values={"DescribeDBInstances"})
    public ListenableFuture<PagedIterable<Instance>> list();

    @Named(value="rds:DescribeDBInstances")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=DescribeDBInstancesResultHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeDBInstances"})
    public ListenableFuture<IterableWithMarker<Instance>> list(ListInstancesOptions var1);

    @Named(value="rds:DeleteDBInstance")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=InstanceHandler.class)
    @ExceptionParser(value=ReturnNullOnStateDeletingNotFoundOr404.class)
    @FormParams(keys={"Action", "SkipFinalSnapshot"}, values={"DeleteDBInstance", "true"})
    public ListenableFuture<Instance> delete(@FormParam(value="DBInstanceIdentifier") String var1);

    @Named(value="rds:DeleteDBInstance")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=InstanceHandler.class)
    @ExceptionParser(value=ReturnNullOnStateDeletingNotFoundOr404.class)
    @FormParams(keys={"Action"}, values={"DeleteDBInstance"})
    public ListenableFuture<Instance> deleteAndSaveSnapshot(@FormParam(value="DBInstanceIdentifier") String var1, @FormParam(value="FinalDBSnapshotIdentifier") String var2);
}

