/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.rds.domain.SecurityGroup;
import org.jclouds.rds.functions.SecurityGroupsToPagedIterable;
import org.jclouds.rds.options.ListSecurityGroupsOptions;
import org.jclouds.rds.xml.DescribeDBSecurityGroupsResultHandler;
import org.jclouds.rds.xml.SecurityGroupHandler;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface SecurityGroupAsyncApi {
    @Named(value="rds:CreateDBSecurityGroup")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"CreateDBSecurityGroup"})
    public ListenableFuture<SecurityGroup> createWithNameAndDescription(@FormParam(value="DBSecurityGroupName") String var1, @FormParam(value="DBSecurityGroupDescription") String var2);

    @Named(value="rds:CreateDBSecurityGroup")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"CreateDBSecurityGroup"})
    public ListenableFuture<SecurityGroup> createInVPCWithNameAndDescription(@FormParam(value="EC2VpcId") String var1, @FormParam(value="DBSecurityGroupName") String var2, @FormParam(value="DBSecurityGroupDescription") String var3);

    @Named(value="rds:DescribeDBSecurityGroups")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeDBSecurityGroups"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<SecurityGroup> get(@FormParam(value="DBSecurityGroupName") String var1);

    @Named(value="rds:DescribeDBSecurityGroups")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=DescribeDBSecurityGroupsResultHandler.class)
    @Transform(value=SecurityGroupsToPagedIterable.class)
    @FormParams(keys={"Action"}, values={"DescribeDBSecurityGroups"})
    public ListenableFuture<PagedIterable<SecurityGroup>> list();

    @Named(value="rds:DescribeDBSecurityGroups")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=DescribeDBSecurityGroupsResultHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeDBSecurityGroups"})
    public ListenableFuture<IterableWithMarker<SecurityGroup>> list(ListSecurityGroupsOptions var1);

    @Named(value="rds:AuthorizeDBSecurityGroupIngress")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"AuthorizeDBSecurityGroupIngress"})
    public ListenableFuture<SecurityGroup> authorizeIngressToIPRange(@FormParam(value="DBSecurityGroupName") String var1, @FormParam(value="CIDRIP") String var2);

    @Named(value="rds:AuthorizeDBSecurityGroupIngress")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"AuthorizeDBSecurityGroupIngress"})
    public ListenableFuture<SecurityGroup> authorizeIngressToEC2SecurityGroupOfOwner(@FormParam(value="DBSecurityGroupName") String var1, @FormParam(value="EC2SecurityGroupName") String var2, @FormParam(value="EC2SecurityGroupOwnerId") String var3);

    @Named(value="rds:AuthorizeDBSecurityGroupIngress")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"AuthorizeDBSecurityGroupIngress"})
    public ListenableFuture<SecurityGroup> authorizeIngressToVPCSecurityGroup(@FormParam(value="DBSecurityGroupName") String var1, @FormParam(value="EC2SecurityGroupId") String var2);

    @Named(value="rds:RevokeDBSecurityGroupIngress")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"RevokeDBSecurityGroupIngress"})
    public ListenableFuture<SecurityGroup> revokeIngressFromIPRange(@FormParam(value="DBSecurityGroupName") String var1, @FormParam(value="CIDRIP") String var2);

    @Named(value="rds:RevokeDBSecurityGroupIngress")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"RevokeDBSecurityGroupIngress"})
    public ListenableFuture<SecurityGroup> revokeIngressFromEC2SecurityGroupOfOwner(@FormParam(value="DBSecurityGroupName") String var1, @FormParam(value="EC2SecurityGroupName") String var2, @FormParam(value="EC2SecurityGroupOwnerId") String var3);

    @Named(value="rds:RevokeDBSecurityGroupIngress")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SecurityGroupHandler.class)
    @FormParams(keys={"Action"}, values={"RevokeDBSecurityGroupIngress"})
    public ListenableFuture<SecurityGroup> revokeIngressFromVPCSecurityGroup(@FormParam(value="DBSecurityGroupName") String var1, @FormParam(value="EC2SecurityGroupId") String var2);

    @Named(value="rds:DeleteDBSecurityGroup")
    @POST
    @Path(value="/")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @FormParams(keys={"Action"}, values={"DeleteDBSecurityGroup"})
    public ListenableFuture<Void> delete(@FormParam(value="DBSecurityGroupName") String var1);
}

