/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.rds.domain.SubnetGroup;
import org.jclouds.rds.functions.SubnetGroupsToPagedIterable;
import org.jclouds.rds.options.ListSubnetGroupsOptions;
import org.jclouds.rds.xml.DescribeDBSubnetGroupsResultHandler;
import org.jclouds.rds.xml.SubnetGroupHandler;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface SubnetGroupAsyncApi {
    @Named(value="rds:DescribeDBSubnetGroups")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SubnetGroupHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeDBSubnetGroups"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<SubnetGroup> get(@FormParam(value="DBSubnetGroupName") String var1);

    @Named(value="rds:DescribeDBSubnetGroups")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=DescribeDBSubnetGroupsResultHandler.class)
    @Transform(value=SubnetGroupsToPagedIterable.class)
    @FormParams(keys={"Action"}, values={"DescribeDBSubnetGroups"})
    public ListenableFuture<PagedIterable<SubnetGroup>> list();

    @Named(value="rds:DescribeDBSubnetGroups")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=DescribeDBSubnetGroupsResultHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeDBSubnetGroups"})
    public ListenableFuture<IterableWithMarker<SubnetGroup>> list(ListSubnetGroupsOptions var1);

    @Named(value="rds:DeleteDBSubnetGroup")
    @POST
    @Path(value="/")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @FormParams(keys={"Action"}, values={"DeleteDBSubnetGroup"})
    public ListenableFuture<Void> delete(@FormParam(value="DBSubnetGroupName") String var1);
}

