/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.rds.RDSApi;
import org.jclouds.rds.domain.Instance;
import org.jclouds.rds.features.InstanceApi;
import org.jclouds.rds.options.ListInstancesOptions;

@Beta
public class InstancesToPagedIterable
extends CallerArg0ToPagedIterable<Instance, InstancesToPagedIterable> {
    private final RDSApi api;

    @Inject
    protected InstancesToPagedIterable(RDSApi api) {
        this.api = (RDSApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Instance>> markerToNextForCallingArg0(final String arg0) {
        final InstanceApi instanceApi = this.api.getInstanceApiForRegion(arg0);
        return new Function<Object, IterableWithMarker<Instance>>(){

            public IterableWithMarker<Instance> apply(Object input) {
                return instanceApi.list(ListInstancesOptions.Builder.afterMarker(input));
            }

            public String toString() {
                return "listInstancesInRegion(" + arg0 + ")";
            }
        };
    }
}

