/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.rds.RDSApi;
import org.jclouds.rds.domain.SecurityGroup;
import org.jclouds.rds.features.SecurityGroupApi;
import org.jclouds.rds.options.ListSecurityGroupsOptions;

@Beta
public class SecurityGroupsToPagedIterable
extends CallerArg0ToPagedIterable<SecurityGroup, SecurityGroupsToPagedIterable> {
    private final RDSApi api;

    @Inject
    protected SecurityGroupsToPagedIterable(RDSApi api) {
        this.api = (RDSApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<SecurityGroup>> markerToNextForCallingArg0(final String arg0) {
        final SecurityGroupApi securityGroupApi = this.api.getSecurityGroupApiForRegion(arg0);
        return new Function<Object, IterableWithMarker<SecurityGroup>>(){

            public IterableWithMarker<SecurityGroup> apply(Object input) {
                return securityGroupApi.list(ListSecurityGroupsOptions.Builder.afterMarker(input));
            }

            public String toString() {
                return "listSecurityGroupsInRegion(" + arg0 + ")";
            }
        };
    }
}

