/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.rds.RDSApi;
import org.jclouds.rds.domain.SubnetGroup;
import org.jclouds.rds.features.SubnetGroupApi;
import org.jclouds.rds.options.ListSubnetGroupsOptions;

@Beta
public class SubnetGroupsToPagedIterable
extends CallerArg0ToPagedIterable<SubnetGroup, SubnetGroupsToPagedIterable> {
    private final RDSApi api;

    @Inject
    protected SubnetGroupsToPagedIterable(RDSApi api) {
        this.api = (RDSApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<SubnetGroup>> markerToNextForCallingArg0(final String arg0) {
        final SubnetGroupApi subnetGroupApi = this.api.getSubnetGroupApiForRegion(arg0);
        return new Function<Object, IterableWithMarker<SubnetGroup>>(){

            public IterableWithMarker<SubnetGroup> apply(Object input) {
                return subnetGroupApi.list(ListSubnetGroupsOptions.Builder.afterMarker(input));
            }

            public String toString() {
                return "listSubnetGroupsInRegion(" + arg0 + ")";
            }
        };
    }
}

