/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.options;

import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListInstancesOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Object marker;
    private Set<String> names = Sets.newLinkedHashSet();

    public ListInstancesOptions afterMarker(Object marker) {
        this.marker = marker;
        return this;
    }

    public ListInstancesOptions names(Set<String> names) {
        this.names = names;
        return this;
    }

    public ListInstancesOptions name(String name) {
        this.names.add(name);
        return this;
    }

    public Multimap<String, String> buildFormParameters() {
        Multimap params = super.buildFormParameters();
        if (this.marker != null) {
            params.put((Object)"Marker", (Object)this.marker.toString());
        }
        if (this.names.size() > 0) {
            int nameIndex = 1;
            for (String name : this.names) {
                params.put((Object)("InstanceNames.member." + nameIndex), (Object)name);
                ++nameIndex;
            }
        }
        return params;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.marker, this.names});
    }

    public ListInstancesOptions clone() {
        return new ListInstancesOptions().afterMarker(this.marker).names(this.names);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListInstancesOptions other = (ListInstancesOptions)ListInstancesOptions.class.cast(obj);
        return Objects.equal((Object)this.marker, (Object)other.marker) && Objects.equal(this.names, other.names);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("marker", this.marker).add("names", this.names).toString();
    }

    public static class Builder {
        public static ListInstancesOptions afterMarker(Object marker) {
            return new ListInstancesOptions().afterMarker(marker);
        }

        public static ListInstancesOptions name(String name) {
            return new ListInstancesOptions().name(name);
        }

        public static ListInstancesOptions names(Set<String> names) {
            return new ListInstancesOptions().names(names);
        }
    }
}

