/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.xml;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rds.domain.Instance;
import org.jclouds.rds.xml.InstanceHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DescribeDBInstancesResultHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IterableWithMarker<Instance>> {
    private final InstanceHandler instanceHandler;
    private StringBuilder currentText = new StringBuilder();
    private Set<Instance> instances = Sets.newLinkedHashSet();
    private boolean inInstances;
    private String marker;
    protected int memberDepth;

    @Inject
    public DescribeDBInstancesResultHandler(InstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public IterableWithMarker<Instance> getResult() {
        return IterableWithMarkers.from(this.instances, (Object)this.marker);
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBInstances")) {
            this.inInstances = true;
        }
        if (this.inInstances) {
            this.instanceHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBInstances")) {
            this.inInstances = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBInstance")) {
            this.instances.add(this.instanceHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Marker")) {
            this.marker = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (this.inInstances) {
            this.instanceHandler.endElement(uri, name, qName);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inInstances) {
            this.instanceHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

