/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.xml;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rds.domain.SecurityGroup;
import org.jclouds.rds.xml.SecurityGroupHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DescribeDBSecurityGroupsResultHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IterableWithMarker<SecurityGroup>> {
    private final SecurityGroupHandler securityGroupHander;
    private StringBuilder currentText = new StringBuilder();
    private ImmutableSet.Builder<SecurityGroup> securityGroups = ImmutableSet.builder();
    private boolean inSecurityGroups;
    private String marker;

    @Inject
    public DescribeDBSecurityGroupsResultHandler(SecurityGroupHandler securityGroupHander) {
        this.securityGroupHander = securityGroupHander;
    }

    public IterableWithMarker<SecurityGroup> getResult() {
        return IterableWithMarkers.from((Iterable)this.securityGroups.build(), (Object)this.marker);
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSecurityGroups")) {
            this.inSecurityGroups = true;
        }
        if (this.inSecurityGroups) {
            this.securityGroupHander.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSecurityGroups")) {
            this.inSecurityGroups = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSecurityGroup")) {
            this.securityGroups.add((Object)this.securityGroupHander.getResult());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Marker")) {
            this.marker = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (this.inSecurityGroups) {
            this.securityGroupHander.endElement(uri, name, qName);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inSecurityGroups) {
            this.securityGroupHander.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

