/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.xml;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rds.domain.SubnetGroup;
import org.jclouds.rds.xml.SubnetGroupHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DescribeDBSubnetGroupsResultHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IterableWithMarker<SubnetGroup>> {
    private final SubnetGroupHandler subnetGroupHander;
    private StringBuilder currentText = new StringBuilder();
    private ImmutableSet.Builder<SubnetGroup> subnetGroups = ImmutableSet.builder();
    private boolean inSubnetGroups;
    private String marker;

    @Inject
    public DescribeDBSubnetGroupsResultHandler(SubnetGroupHandler subnetGroupHander) {
        this.subnetGroupHander = subnetGroupHander;
    }

    public IterableWithMarker<SubnetGroup> getResult() {
        return IterableWithMarkers.from((Iterable)this.subnetGroups.build(), (Object)this.marker);
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSubnetGroups")) {
            this.inSubnetGroups = true;
        }
        if (this.inSubnetGroups) {
            this.subnetGroupHander.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSubnetGroups")) {
            this.inSubnetGroups = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSubnetGroup")) {
            this.subnetGroups.add((Object)this.subnetGroupHander.getResult());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Marker")) {
            this.marker = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (this.inSubnetGroups) {
            this.subnetGroupHander.endElement(uri, name, qName);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inSubnetGroups) {
            this.subnetGroupHander.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

