/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.xml;

import org.jclouds.http.functions.ParseSax;
import org.jclouds.rds.domain.Authorization;
import org.jclouds.rds.domain.EC2SecurityGroup;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

public class EC2SecurityGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<EC2SecurityGroup> {
    private StringBuilder currentText = new StringBuilder();
    private EC2SecurityGroup.Builder builder = EC2SecurityGroup.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EC2SecurityGroup getResult() {
        try {
            EC2SecurityGroup eC2SecurityGroup = this.builder.build();
            return eC2SecurityGroup;
        }
        finally {
            this.builder = EC2SecurityGroup.builder();
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"EC2SecurityGroupId")) {
            this.builder.id(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"EC2SecurityGroupName")) {
            this.builder.name(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"EC2SecurityGroupOwnerId")) {
            this.builder.ownerId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Status")) {
            String rawStatus = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.builder.rawStatus(rawStatus);
            this.builder.status(Authorization.Status.fromValue(rawStatus));
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

