/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.xml;

import org.jclouds.http.functions.ParseSax;
import org.jclouds.rds.domain.Authorization;
import org.jclouds.rds.domain.IPRange;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

public class IPRangeHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IPRange> {
    private StringBuilder currentText = new StringBuilder();
    private IPRange.Builder builder = IPRange.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPRange getResult() {
        try {
            IPRange iPRange = this.builder.build();
            return iPRange;
        }
        finally {
            this.builder = IPRange.builder();
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"CIDRIP")) {
            this.builder.cidrIp(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Status")) {
            String rawStatus = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.builder.rawStatus(rawStatus);
            this.builder.status(Authorization.Status.fromValue(rawStatus));
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

