/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rds.domain.Instance;
import org.jclouds.rds.xml.SubnetGroupHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InstanceHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Instance> {
    protected final DateService dateService;
    protected final SubnetGroupHandler subnetGroupHandler;
    private StringBuilder currentText = new StringBuilder();
    private Instance.Builder<?> builder = Instance.builder();
    private boolean inSubnetGroup;
    private String address;
    private Integer port;
    private ImmutableMap.Builder<String, String> securityGroupBuilder = ImmutableMap.builder();
    private String groupName;
    private String status;

    @Inject
    protected InstanceHandler(DateService dateService, SubnetGroupHandler subnetGroupHandler) {
        this.dateService = dateService;
        this.subnetGroupHandler = subnetGroupHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance getResult() {
        try {
            Instance instance = this.builder.build();
            return instance;
        }
        finally {
            this.builder = Instance.builder();
        }
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSubnetGroup")) {
            this.inSubnetGroup = true;
        }
        if (this.inSubnetGroup) {
            this.subnetGroupHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSubnetGroup")) {
            this.builder.subnetGroup(this.subnetGroupHandler.getResult());
            this.inSubnetGroup = false;
        } else if (this.inSubnetGroup) {
            this.subnetGroupHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBInstanceIdentifier")) {
            this.builder.id(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"InstanceCreateTime")) {
            this.builder.createdTime(this.dateService.iso8601DateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBName")) {
            this.builder.name(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"AllocatedStorage")) {
            this.builder.allocatedStorageGB(Integer.parseInt(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBInstanceStatus")) {
            String rawStatus = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.builder.rawStatus(rawStatus);
            this.builder.status(Instance.Status.fromValue(rawStatus));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Address")) {
            this.address = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Port")) {
            this.port = Integer.valueOf(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Endpoint")) {
            if (this.address != null && this.port != null) {
                this.builder.endpoint(HostAndPort.fromParts((String)this.address, (int)this.port));
            }
            this.address = null;
            this.port = null;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSecurityGroupName")) {
            this.groupName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Status")) {
            this.status = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSecurityGroup")) {
            this.securityGroupBuilder.put((Object)this.groupName, (Object)this.status);
            this.status = null;
            this.groupName = null;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSecurityGroups")) {
            this.builder.securityGroupNameToStatus((Map<String, String>)this.securityGroupBuilder.build());
            this.securityGroupBuilder = ImmutableMap.builder();
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBInstanceClass")) {
            this.builder.instanceClass(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"AvailabilityZone")) {
            this.builder.availabilityZone(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"MultiAZ")) {
            this.builder.multiAZ(Boolean.parseBoolean(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Engine")) {
            this.builder.engine(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"EngineVersion")) {
            this.builder.engineVersion(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"LicenseModel")) {
            this.builder.licenseModel(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"MasterUsername")) {
            this.builder.masterUsername(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inSubnetGroup) {
            this.subnetGroupHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

