/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.xml;

import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rds.domain.SecurityGroup;
import org.jclouds.rds.xml.EC2SecurityGroupHandler;
import org.jclouds.rds.xml.IPRangeHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SecurityGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<SecurityGroup> {
    protected final EC2SecurityGroupHandler ec2SecurityGroupHandler;
    protected final IPRangeHandler ipRangeHandler;
    private StringBuilder currentText = new StringBuilder();
    private SecurityGroup.Builder<?> builder = SecurityGroup.builder();
    private boolean inEC2SecurityGroups;
    private boolean inIPRanges;

    @Inject
    protected SecurityGroupHandler(EC2SecurityGroupHandler ec2SecurityGroupHandler, IPRangeHandler ipRangeHandler) {
        this.ec2SecurityGroupHandler = ec2SecurityGroupHandler;
        this.ipRangeHandler = ipRangeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityGroup getResult() {
        try {
            SecurityGroup securityGroup = this.builder.build();
            return securityGroup;
        }
        finally {
            this.builder = SecurityGroup.builder();
        }
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"EC2SecurityGroups")) {
            this.inEC2SecurityGroups = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"IPRanges")) {
            this.inIPRanges = true;
        }
        if (this.inEC2SecurityGroups) {
            this.ec2SecurityGroupHandler.startElement(url, name, qName, attributes);
        } else if (this.inIPRanges) {
            this.ipRangeHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"EC2SecurityGroups")) {
            this.inEC2SecurityGroups = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"IPRanges")) {
            this.inIPRanges = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSecurityGroupName")) {
            this.builder.name(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSecurityGroupDescription")) {
            this.builder.description(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"EC2SecurityGroup")) {
            this.builder.ec2SecurityGroup(this.ec2SecurityGroupHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"IPRange")) {
            this.builder.ipRange(this.ipRangeHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"OwnerId")) {
            this.builder.ownerId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VpcId")) {
            this.builder.vpcId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (this.inEC2SecurityGroups) {
            this.ec2SecurityGroupHandler.endElement(uri, name, qName);
        } else if (this.inIPRanges) {
            this.ipRangeHandler.endElement(uri, name, qName);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inEC2SecurityGroups) {
            this.ec2SecurityGroupHandler.characters(ch, start, length);
        } else if (this.inIPRanges) {
            this.ipRangeHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

