/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rds.xml;

import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rds.domain.SubnetGroup;
import org.jclouds.rds.xml.SubnetHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubnetGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<SubnetGroup> {
    protected final SubnetHandler subnetHandler;
    private StringBuilder currentText = new StringBuilder();
    private SubnetGroup.Builder<?> builder = SubnetGroup.builder();
    private boolean inSubnets;

    @Inject
    protected SubnetGroupHandler(SubnetHandler subnetHandler) {
        this.subnetHandler = subnetHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubnetGroup getResult() {
        try {
            SubnetGroup subnetGroup = this.builder.build();
            return subnetGroup;
        }
        finally {
            this.builder = SubnetGroup.builder();
        }
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Subnets")) {
            this.inSubnets = true;
        }
        if (this.inSubnets) {
            this.subnetHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Subnets")) {
            this.inSubnets = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSubnetGroupName")) {
            this.builder.name(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"DBSubnetGroupDescription")) {
            this.builder.description(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"SubnetGroupStatus")) {
            this.builder.status(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Subnet")) {
            this.builder.subnet(this.subnetHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VpcId")) {
            this.builder.vpcId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (this.inSubnets) {
            this.subnetHandler.endElement(uri, name, qName);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inSubnets) {
            this.subnetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

