/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jenkinsci.bytecode.AdapterAnnotation;
import org.jenkinsci.bytecode.AdapterAnnotationParser;
import org.jenkinsci.bytecode.MemberAdapter;
import org.jenkinsci.bytecode.TransformationSpec;
import org.jvnet.hudson.annotation_indexer.Indexed;
import org.kohsuke.asm3.MethodVisitor;
import org.kohsuke.asm3.Type;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
@Indexed
@AdapterAnnotation(value=FactoryImpl.class)
public @interface AdaptField {
    public String name() default "";

    public Class[] was();

    public static class FactoryImpl
    extends AdapterAnnotationParser {
        void parse(TransformationSpec spec, AnnotatedElement e) {
            AdaptField af = e.getAnnotation(AdaptField.class);
            Member mem = (Member)((Object)e);
            String name = af.name();
            if (name.length() == 0) {
                name = mem.getName();
            }
            MemberAdapter mrs = null;
            if (e instanceof Field) {
                mrs = this.fieldToField((Field)e);
            }
            if (e instanceof Method) {
                mrs = this.fieldToMethod((Method)e);
            }
            assert (mrs != null);
            for (Class was : af.was()) {
                spec.fields.addRewriteSpec(name, was, mrs);
            }
        }

        MemberAdapter fieldToField(Field f) {
            final String newName = f.getName();
            final Type newType = Type.getType(f.getType());
            final String newTypeDescriptor = newType.getDescriptor();
            final String newTypeInternalName = FactoryImpl.isReferenceType(newType) ? newType.getInternalName() : null;
            return new MemberAdapter(f){

                boolean adapt(int opcode, String owner, String name, String desc, MethodVisitor delegate) {
                    switch (opcode) {
                        case 178: 
                        case 180: {
                            delegate.visitFieldInsn(opcode, owner, newName, newTypeDescriptor);
                            Type t = Type.getType((String)desc);
                            if (FactoryImpl.isReferenceType(t)) {
                                delegate.visitTypeInsn(192, t.getInternalName());
                            }
                            return true;
                        }
                        case 179: 
                        case 181: {
                            if (FactoryImpl.isReferenceType(newType)) {
                                delegate.visitTypeInsn(192, newTypeInternalName);
                            }
                            delegate.visitFieldInsn(opcode, owner, newName, newTypeDescriptor);
                            return true;
                        }
                    }
                    return false;
                }
            };
        }

        MemberAdapter fieldToMethod(Method m) {
            boolean isGetter;
            Class<?>[] params = m.getParameterTypes();
            boolean bl = isGetter = params.length == 0;
            if (Modifier.isStatic(m.getModifiers())) {
                if (isGetter) {
                    return new GetFieldAdapter(m, 178, 184);
                }
                return new SetFieldAdapter(m, 179, 184);
            }
            if (isGetter) {
                return new GetFieldAdapter(m, 180, 182);
            }
            return new SetFieldAdapter(m, 181, 182);
        }

        private static boolean isReferenceType(Type t) {
            return t.getSort() == 9 || t.getSort() == 10;
        }

        private static class SetFieldAdapter
        extends FieldToMethodAdapter {
            private SetFieldAdapter(Method m, int fieldOpcode, int invokeOpcode) {
                super(m, fieldOpcode, invokeOpcode);
            }

            boolean adapt(int opcode, String owner, String name, String desc, MethodVisitor delegate) {
                Type t;
                boolean expectedReference;
                if (opcode == this.fieldOpcode && this.actuallyPrimitive ^ (expectedReference = FactoryImpl.isReferenceType(t = Type.getType((String)desc)))) {
                    delegate.visitMethodInsn(this.invokeOpcode, owner, this.methodName, this.methodDescriptor);
                    return true;
                }
                return false;
            }
        }

        private static class GetFieldAdapter
        extends FieldToMethodAdapter {
            private GetFieldAdapter(Method m, int fieldOpcode, int invokeOpcode) {
                super(m, fieldOpcode, invokeOpcode);
            }

            boolean adapt(int opcode, String owner, String name, String desc, MethodVisitor delegate) {
                Type t;
                boolean expectedReference;
                if (opcode == this.fieldOpcode && this.actuallyPrimitive ^ (expectedReference = FactoryImpl.isReferenceType(t = Type.getType((String)desc)))) {
                    delegate.visitMethodInsn(this.invokeOpcode, owner, this.methodName, this.methodDescriptor);
                    if (expectedReference) {
                        delegate.visitTypeInsn(192, t.getInternalName());
                    }
                    return true;
                }
                return false;
            }
        }

        private static class FieldToMethodAdapter
        extends MemberAdapter {
            final boolean actuallyPrimitive;
            final String methodName;
            final String methodDescriptor;
            final int fieldOpcode;
            final int invokeOpcode;

            public FieldToMethodAdapter(Method m, int fieldOpcode, int invokeOpcode) {
                super(m);
                this.methodName = m.getName();
                this.methodDescriptor = Type.getMethodDescriptor((Method)m);
                Class<?>[] params = m.getParameterTypes();
                boolean isGetter = params.length == 0;
                this.actuallyPrimitive = isGetter ? m.getReturnType().isPrimitive() : params[0].isPrimitive();
                this.fieldOpcode = fieldOpcode;
                this.invokeOpcode = invokeOpcode;
            }
        }
    }
}

