/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.lang.reflect.Member;
import org.kohsuke.asm3.MethodVisitor;
import org.kohsuke.asm3.Type;

abstract class MemberAdapter {
    final Type owner;

    protected MemberAdapter(Type owner) {
        this.owner = owner;
    }

    protected MemberAdapter(Class owner) {
        this.owner = Type.getType((Class)owner);
    }

    protected MemberAdapter(Member member) {
        this(member.getDeclaringClass());
    }

    boolean adapt(int opcode, String owner, String name, String desc, MethodVisitor delegate) {
        return false;
    }

    MemberAdapter compose(final MemberAdapter rhs) {
        if (rhs == null) {
            return this;
        }
        assert (this.owner.equals((Object)rhs.owner));
        final MemberAdapter lhs = this;
        return new MemberAdapter(this.owner){

            boolean adapt(int opcode, String owner, String name, String desc, MethodVisitor delegate) {
                return lhs.adapt(opcode, owner, name, desc, delegate) || rhs.adapt(opcode, owner, name, desc, delegate);
            }
        };
    }
}

