/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jenkinsci.bytecode.TransformationSpec;
import org.kohsuke.asm3.ClassAdapter;
import org.kohsuke.asm3.ClassReader;
import org.kohsuke.asm3.ClassVisitor;
import org.kohsuke.asm3.ClassWriter;
import org.kohsuke.asm3.MethodAdapter;
import org.kohsuke.asm3.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer {
    private volatile TransformationSpec spec = new TransformationSpec();

    public void loadRules(ClassLoader cl) throws IOException {
        this.loadRules(Collections.singleton(cl));
    }

    public synchronized void loadRules(Collection<? extends ClassLoader> loaders) throws IOException {
        TransformationSpec spec = new TransformationSpec(this.spec);
        for (ClassLoader classLoader : loaders) {
            spec.loadRule(classLoader);
        }
        this.spec = spec;
    }

    public byte[] transform(String className, byte[] image) {
        if (!this.spec.mayNeedTransformation(image)) {
            return image;
        }
        ClassReader cr = new ClassReader(image);
        ClassWriter cw = new ClassWriter(1);
        final boolean[] modified = new boolean[1];
        cr.accept((ClassVisitor)new ClassAdapter((ClassVisitor)cw){

            public MethodVisitor visitMethod(int access, String methodName, String methodDescriptor, String methodSignature, String[] exceptions) {
                final MethodVisitor base = super.visitMethod(access, methodName, methodDescriptor, methodSignature, exceptions);
                return new MethodAdapter(base){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        modified[0] = modified[0] | ((Transformer)Transformer.this).spec.methods.rewrite(opcode, owner, name, desc, base);
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        modified[0] = modified[0] | ((Transformer)Transformer.this).spec.fields.rewrite(opcode, owner, name, desc, base);
                    }
                };
            }
        }, 4);
        if (!modified[0]) {
            return image;
        }
        return cw.toByteArray();
    }
}

