/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.Domination;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class StaticImportResolveProcessor
implements NameHint,
PsiScopeProcessor {
    private final PsiImportStaticReferenceElement myReference;
    private final String myName;
    private final List<JavaResolveResult> myFieldResults;
    private final List<JavaResolveResult> myClassResult;
    private final List<JavaResolveResult> myResults;

    public StaticImportResolveProcessor(@NotNull PsiImportStaticReferenceElement reference) {
        if (reference == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(0);
        }
        this.myFieldResults = new SmartList<JavaResolveResult>();
        this.myClassResult = new SmartList<JavaResolveResult>();
        this.myResults = new SmartList<JavaResolveResult>();
        this.myReference = reference;
        this.myName = this.myReference.getReferenceName();
    }

    @Override
    public boolean execute(@NotNull PsiElement candidate2, @NotNull ResolveState state2) {
        if (candidate2 == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(1);
        }
        if (state2 == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(2);
        }
        if (candidate2 instanceof PsiMember && ((PsiModifierListOwner)candidate2).hasModifierProperty("static")) {
            if (candidate2 instanceof PsiField) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate2, this.myFieldResults)) {
                    return true;
                }
                this.myFieldResults.add(new OurResolveResult(candidate2, this.myReference));
            } else if (candidate2 instanceof PsiClass) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate2, this.myClassResult)) {
                    return true;
                }
                this.myClassResult.add(new OurResolveResult(candidate2, this.myReference));
            } else {
                this.myResults.add(new OurResolveResult(candidate2, this.myReference));
            }
        }
        return true;
    }

    private static boolean checkDomination(PsiMember candidate2, List<JavaResolveResult> results) {
        if (!results.isEmpty()) {
            ListIterator<JavaResolveResult> i = results.listIterator(results.size());
            while (i.hasPrevious()) {
                Domination domination = StaticImportResolveProcessor.dominates(candidate2, (PsiMember)i.previous().getElement());
                if (domination == Domination.DOMINATED_BY) {
                    return true;
                }
                if (domination != Domination.DOMINATES) continue;
                i.remove();
            }
        }
        return false;
    }

    private static Domination dominates(PsiMember member1, PsiMember member2) {
        PsiClass class1 = member1.getContainingClass();
        PsiClass class2 = member2.getContainingClass();
        if (class1 != null && class2 != null) {
            if (class1.isInheritor(class2, true)) {
                return Domination.DOMINATES;
            }
            if (class2.isInheritor(class1, true)) {
                return Domination.DOMINATED_BY;
            }
        }
        return Domination.EQUAL;
    }

    @Override
    public String getName(@NotNull ResolveState state2) {
        if (state2 == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(3);
        }
        return this.myName;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(4);
        }
        if (hintKey == NameHint.KEY) {
            return (T)this;
        }
        return null;
    }

    @NotNull
    public JavaResolveResult[] getResults() {
        if (this.myResults.size() + this.myFieldResults.size() + this.myClassResult.size() > 1) {
            StaticImportResolveProcessor.filterInvalid(this.myResults);
            StaticImportResolveProcessor.filterInvalid(this.myFieldResults);
            StaticImportResolveProcessor.filterInvalid(this.myClassResult);
        }
        if (!this.myFieldResults.isEmpty()) {
            this.myResults.addAll(this.myFieldResults);
        }
        if (!this.myClassResult.isEmpty()) {
            this.myResults.addAll(this.myClassResult);
        }
        JavaResolveResult[] javaResolveResultArray = this.myResults.toArray(JavaResolveResult.EMPTY_ARRAY);
        if (javaResolveResultArray == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(5);
        }
        return javaResolveResultArray;
    }

    private static void filterInvalid(List<JavaResolveResult> resultList) {
        if (resultList.isEmpty()) {
            return;
        }
        ListIterator<JavaResolveResult> i = resultList.listIterator(resultList.size());
        while (i.hasPrevious()) {
            if (i.previous().isValidResult()) continue;
            i.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OurResolveResult
    extends CandidateInfo {
        private final PsiImportStaticReferenceElement myReference;

        OurResolveResult(@NotNull PsiElement candidate2, PsiImportStaticReferenceElement reference) {
            if (candidate2 == null) {
                OurResolveResult.$$$reportNull$$$0(0);
            }
            super(candidate2, PsiSubstitutor.EMPTY);
            this.myReference = reference;
        }

        @Override
        public boolean isAccessible() {
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(this.myReference.getProject()).getResolveHelper();
            PsiElement element = this.getElement();
            return element instanceof PsiMember && resolveHelper.isAccessible((PsiMember)element, this.myReference, null);
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor$OurResolveResult", "<init>"));
        }
    }
}

