/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.DeprecatedCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ApiVersionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "frontend"})
public final class ApiVersionCallChecker
implements CallChecker {
    public static final ApiVersionCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        this.check((CallableDescriptor)obj, context, reportOn);
    }

    private final void check(CallableDescriptor targetDescriptor, CallCheckerContext context, PsiElement element) {
        block3: {
            if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                return;
            }
            SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(targetDescriptor, context.getLanguageVersionSettings());
            if (accessibility instanceof SinceKotlinAccessibility.NotAccessible) {
                context.getTrace().report(Errors.API_NOT_AVAILABLE.on(element, ((SinceKotlinAccessibility.NotAccessible)accessibility).getVersion().getVersionString(), context.getLanguageVersionSettings().getApiVersion().getVersionString()));
            }
            if (!Intrinsics.areEqual((Object)accessibility, (Object)SinceKotlinAccessibility.Accessible.INSTANCE) || !(targetDescriptor instanceof PropertyDescriptor) || !DeprecatedCallChecker.INSTANCE.shouldCheckPropertyGetter$frontend(element)) break block3;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor propertyGetterDescriptor2 = propertyGetterDescriptor;
                boolean bl = false;
                boolean bl2 = false;
                PropertyGetterDescriptor it = propertyGetterDescriptor2;
                boolean bl3 = false;
                PropertyGetterDescriptor propertyGetterDescriptor3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor3, (String)"it");
                INSTANCE.check(propertyGetterDescriptor3, context, element);
            }
        }
    }

    private ApiVersionCallChecker() {
    }

    static {
        ApiVersionCallChecker apiVersionCallChecker;
        INSTANCE = apiVersionCallChecker = new ApiVersionCallChecker();
    }
}

