/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport$Companion$WhenMappings;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.DefaultDiagnosticReporter;
import org.jetbrains.kotlin.cli.common.messages.DiagnosticMessageReporter;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.codegen.state.IncompatibleClassTrackerImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.load.java.components.TraceBasedErrorReporter;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0002J\u0016\u0010\u001b\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport;", "Lorg/jetbrains/kotlin/analyzer/AbstractAnalyzerWithCompilerReport;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "analysisResult", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "setAnalysisResult", "(Lorg/jetbrains/kotlin/analyzer/AnalysisResult;)V", "analyzeAndReport", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "analyze", "Lkotlin/Function0;", "hasErrors", "", "reportAlternativeSignatureErrors", "reportIncompleteHierarchies", "reportSyntaxErrors", "Companion", "MyDiagnostic", "SyntaxErrorReport", "cli"})
public final class AnalyzerWithCompilerReport
implements AbstractAnalyzerWithCompilerReport {
    @NotNull
    public AnalysisResult analysisResult;
    private final MessageCollector messageCollector;
    private final LanguageVersionSettings languageVersionSettings;
    private static final DiagnosticFactory0<PsiErrorElement> SYNTAX_ERROR_FACTORY;
    public static final Companion Companion;

    @Override
    @NotNull
    public AnalysisResult getAnalysisResult() {
        AnalysisResult analysisResult2 = this.analysisResult;
        if (analysisResult2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"analysisResult");
        }
        return analysisResult2;
    }

    public void setAnalysisResult(@NotNull AnalysisResult analysisResult2) {
        Intrinsics.checkParameterIsNotNull((Object)analysisResult2, (String)"<set-?>");
        this.analysisResult = analysisResult2;
    }

    private final void reportIncompleteHierarchies() {
        BindingContext bindingContext = this.getAnalysisResult().getBindingContext();
        Collection<ClassDescriptor> classes2 = bindingContext.getKeys(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY);
        if (!classes2.isEmpty()) {
            StringBuilder message2 = new StringBuilder("Supertypes of the following classes cannot be resolved. Please make sure you have the required dependencies in the classpath:\n");
            for (ClassDescriptor descriptor2 : classes2) {
                String fqName2 = DescriptorUtils.getFqName(descriptor2).asString();
                List unresolved = (List)bindingContext.get(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY, descriptor2);
                boolean bl = unresolved != null && !unresolved.isEmpty();
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Incomplete hierarchy should be reported with names of unresolved superclasses: " + fqName2;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                StringBuilder stringBuilder2 = message2.append("    class ").append(fqName2).append(", unresolved supertypes: ");
                List list2 = unresolved;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"unresolved!!");
                stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null)).append("\n");
            }
            String string3 = message2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"message.toString()");
            MessageCollector.DefaultImpls.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string3, null, 4, null);
        }
    }

    private final void reportAlternativeSignatureErrors() {
        BindingContext bc = this.getAnalysisResult().getBindingContext();
        Collection<DeclarationDescriptor> descriptorsWithErrors = bc.getKeys(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        if (!descriptorsWithErrors.isEmpty()) {
            StringBuilder message2 = new StringBuilder("The following Java entities have annotations with wrong Kotlin signatures:\n");
            Iterator<DeclarationDescriptor> iterator2 = descriptorsWithErrors.iterator();
            while (iterator2.hasNext()) {
                DeclarationDescriptor descriptor2;
                DeclarationDescriptor declarationDescriptor = descriptor2 = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor");
                PsiElement declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                boolean bl = declaration2 instanceof PsiModifierListOwner;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                List errors = (List)bc.get(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2);
                bl2 = errors != null && !errors.isEmpty();
                bl3 = false;
                boolean bl5 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl6 = false;
                    String string3 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                PsiElement psiElement = declaration2;
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                }
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)psiElement);
                message2.append(externalName).append(":\n");
                List list2 = errors;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                for (String error : list2) {
                    message2.append("    ").append(error).append("\n");
                }
            }
            String string4 = message2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"message.toString()");
            MessageCollector.DefaultImpls.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string4, null, 4, null);
        }
    }

    private final void reportSyntaxErrors(Collection<? extends KtFile> files2) {
        for (KtFile ktFile : files2) {
            Companion.reportSyntaxErrors((PsiElement)ktFile, this.messageCollector);
        }
    }

    @Override
    public boolean hasErrors() {
        return this.messageCollector.hasErrors();
    }

    @Override
    public void analyzeAndReport(@NotNull Collection<? extends KtFile> files2, @NotNull Function0<? extends AnalysisResult> analyze2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull(analyze2, (String)"analyze");
        this.setAnalysisResult((AnalysisResult)analyze2.invoke());
        ExperimentalUsageChecker.Companion.checkCompilerArguments(this.getAnalysisResult().getModuleDescriptor(), this.languageVersionSettings, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ AnalyzerWithCompilerReport this$0;

            public final void invoke(@NotNull String message2) {
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                MessageCollector.DefaultImpls.report$default(AnalyzerWithCompilerReport.access$getMessageCollector$p(this.this$0), CompilerMessageSeverity.ERROR, message2, null, 4, null);
            }
            {
                this.this$0 = analyzerWithCompilerReport;
                super(1);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ AnalyzerWithCompilerReport this$0;

            public final void invoke(@NotNull String message2) {
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                MessageCollector.DefaultImpls.report$default(AnalyzerWithCompilerReport.access$getMessageCollector$p(this.this$0), CompilerMessageSeverity.WARNING, message2, null, 4, null);
            }
            {
                this.this$0 = analyzerWithCompilerReport;
                super(1);
            }
        }));
        this.reportSyntaxErrors(files2);
        Diagnostics diagnostics2 = this.getAnalysisResult().getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics2, (String)"analysisResult.bindingContext.diagnostics");
        Companion.reportDiagnostics(diagnostics2, this.messageCollector);
        this.reportIncompleteHierarchies();
        this.reportAlternativeSignatureErrors();
    }

    public AnalyzerWithCompilerReport(@NotNull MessageCollector messageCollector, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.messageCollector = messageCollector;
        this.languageVersionSettings = languageVersionSettings;
    }

    public AnalyzerWithCompilerReport(@NotNull CompilerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector == null) {
            messageCollector = MessageCollector.Companion.getNONE();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector, (String)"configuration.get(CLICon\u2026 ?: MessageCollector.NONE");
        this(messageCollector, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration));
    }

    static {
        Companion = new Companion(null);
        SYNTAX_ERROR_FACTORY = DiagnosticFactory0.create(Severity.ERROR);
    }

    public static final /* synthetic */ MessageCollector access$getMessageCollector$p(AnalyzerWithCompilerReport $this) {
        return $this.messageCollector;
    }

    public static final /* synthetic */ DiagnosticFactory0 access$getSYNTAX_ERROR_FACTORY$cp() {
        return SYNTAX_ERROR_FACTORY;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "", "isHasErrors", "", "isAllErrorsAtEof", "(ZZ)V", "()Z", "cli"})
    public static final class SyntaxErrorReport {
        private final boolean isHasErrors;
        private final boolean isAllErrorsAtEof;

        public final boolean isHasErrors() {
            return this.isHasErrors;
        }

        public final boolean isAllErrorsAtEof() {
            return this.isAllErrorsAtEof;
        }

        public SyntaxErrorReport(boolean isHasErrors, boolean isAllErrorsAtEof) {
            this.isHasErrors = isHasErrors;
            this.isAllErrorsAtEof = isAllErrorsAtEof;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic;", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/diagnostics/SimpleDiagnostic;", "psiElement", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "message", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "isValid", "", "cli"})
    private static final class MyDiagnostic<E extends PsiElement>
    extends SimpleDiagnostic<E> {
        @NotNull
        private final String message;

        @Override
        public boolean isValid() {
            return true;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public MyDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactory0<E> factory2, @NotNull String message2) {
            Intrinsics.checkParameterIsNotNull(psiElement, (String)"psiElement");
            Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            super(psiElement, factory2, Severity.ERROR);
            this.message = message2;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0010R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion;", "", "()V", "SYNTAX_ERROR_FACTORY", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;", "kotlin.jvm.PlatformType", "convertSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "reportBytecodeVersionErrors", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reportDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reporter", "Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;", "reportDiagnostics", "unsortedDiagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "diagnostics", "reportIncompatibleBinaryVersion", "data", "Lorg/jetbrains/kotlin/serialization/deserialization/IncompatibleVersionErrorData;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmBytecodeBinaryVersion;", "reportSyntaxErrors", "Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "file", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "cli"})
    public static final class Companion {
        @NotNull
        public final CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
            CompilerMessageSeverity compilerMessageSeverity;
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            switch (AnalyzerWithCompilerReport$Companion$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    compilerMessageSeverity = CompilerMessageSeverity.INFO;
                    break;
                }
                case 2: {
                    compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                    break;
                }
                case 3: {
                    compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unknown severity: " + (Object)((Object)severity));
                }
            }
            return compilerMessageSeverity;
        }

        private final boolean reportDiagnostic(Diagnostic diagnostic, DiagnosticMessageReporter reporter) {
            Object object;
            if (!diagnostic.isValid()) {
                return false;
            }
            PsiFile psiFile = diagnostic.getPsiFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"diagnostic.psiFile");
            Diagnostic diagnostic2 = diagnostic;
            if (!(diagnostic2 instanceof MyDiagnostic)) {
                diagnostic2 = null;
            }
            if ((object = (MyDiagnostic)diagnostic2) == null || (object = ((MyDiagnostic)object).getMessage()) == null) {
                String string2 = DefaultErrorMessages.render(diagnostic);
                object = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DefaultErrorMessages.render(diagnostic)");
            }
            reporter.report(diagnostic, psiFile, (String)object);
            return diagnostic.getSeverity() == Severity.ERROR;
        }

        public final boolean reportDiagnostics(@NotNull Diagnostics unsortedDiagnostics, @NotNull DiagnosticMessageReporter reporter) {
            Intrinsics.checkParameterIsNotNull((Object)unsortedDiagnostics, (String)"unsortedDiagnostics");
            Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
            boolean hasErrors = false;
            List<Diagnostic> diagnostics2 = DiagnosticUtils.sortedDiagnostics(unsortedDiagnostics.all());
            Iterator<Diagnostic> iterator2 = diagnostics2.iterator();
            while (iterator2.hasNext()) {
                Diagnostic diagnostic;
                Diagnostic diagnostic2 = diagnostic = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)diagnostic2, (String)"diagnostic");
                hasErrors |= this.reportDiagnostic(diagnostic2, reporter);
            }
            return hasErrors;
        }

        public final boolean reportDiagnostics(@NotNull Diagnostics diagnostics2, @NotNull MessageCollector messageCollector) {
            boolean bl;
            boolean hasErrors;
            block14: {
                boolean bl2;
                Diagnostic it;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block13: {
                    boolean bl3;
                    block12: {
                        Intrinsics.checkParameterIsNotNull((Object)diagnostics2, (String)"diagnostics");
                        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
                        hasErrors = this.reportDiagnostics(diagnostics2, new DefaultDiagnosticReporter(messageCollector));
                        $this$any$iv = diagnostics2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (Diagnostic)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual(it.getFactory(), Errors.INCOMPATIBLE_CLASS)) continue;
                                bl3 = true;
                                break block12;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Incompatible classes were found in dependencies. Remove them from the classpath or use '-Xskip-metadata-version-check' to suppress errors", null, 4, null);
                    }
                    $this$any$iv = diagnostics2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Diagnostic)element$iv;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual(it.getFactory(), Errors.PRE_RELEASE_CLASS)) continue;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Pre-release classes were found in dependencies. Remove them from the classpath, recompile with a release compiler or use '-Xskip-prerelease-check' to suppress errors", null, 4, null);
                }
                $this$any$iv = diagnostics2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Diagnostic)element$iv;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual(it.getFactory(), Errors.IR_COMPILED_CLASS)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Classes compiled by a new Kotlin compiler backend were found in dependencies. Remove them from the classpath or use '-Xallow-jvm-ir-dependencies' to suppress errors", null, 4, null);
            }
            return hasErrors;
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file2, @NotNull DiagnosticMessageReporter reporter) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)reporter, (String)"reporter");
            @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0004*\u00020\u000fH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0019"}, d2={"org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion$reportSyntaxErrors$ErrorReportingVisitor", "Lorg/jetbrains/kotlin/resolve/AnalyzingUtils$PsiErrorElementVisitor;", "(Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;)V", "allErrorsAtEof", "", "getAllErrorsAtEof", "()Z", "setAllErrorsAtEof", "(Z)V", "hasErrors", "getHasErrors", "setHasErrors", "reportDiagnostic", "", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "element", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "message", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;Ljava/lang/String;)V", "visitErrorElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;", "isAtEof", "cli"})
            public final class ErrorReportingVisitor
            extends AnalyzingUtils.PsiErrorElementVisitor {
                private boolean hasErrors;
                private boolean allErrorsAtEof;
                final /* synthetic */ DiagnosticMessageReporter $reporter;

                public final boolean getHasErrors() {
                    return this.hasErrors;
                }

                public final void setHasErrors(boolean bl) {
                    this.hasErrors = bl;
                }

                public final boolean getAllErrorsAtEof() {
                    return this.allErrorsAtEof;
                }

                public final void setAllErrorsAtEof(boolean bl) {
                    this.allErrorsAtEof = bl;
                }

                private final <E extends PsiElement> void reportDiagnostic(E element, DiagnosticFactory0<E> factory2, String message2) {
                    MyDiagnostic<E> diagnostic = new MyDiagnostic<E>(element, factory2, message2);
                    org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport$Companion.access$reportDiagnostic(AnalyzerWithCompilerReport.Companion, diagnostic, this.$reporter);
                    if (this.allErrorsAtEof && !this.isAtEof(element)) {
                        this.allErrorsAtEof = false;
                    }
                    this.hasErrors = true;
                }

                private final boolean isAtEof(PsiElement $receiver) {
                    PsiElement element = $receiver;
                    do {
                        if (element.getNextSibling() != null) continue;
                        return true;
                    } while (element instanceof PsiWhiteSpace && element instanceof PsiComment);
                    return false;
                }

                public void visitErrorElement(@NotNull PsiErrorElement element) {
                    String string2;
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    String description2 = element.getErrorDescription();
                    PsiElement psiElement = element;
                    DiagnosticFactory0 diagnosticFactory0 = AnalyzerWithCompilerReport.access$getSYNTAX_ERROR_FACTORY$cp();
                    Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticFactory0, (String)"SYNTAX_ERROR_FACTORY");
                    if (StringUtil.isEmpty(description2)) {
                        string2 = "Syntax error";
                    } else {
                        String string3 = description2;
                        string2 = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"description");
                    }
                    this.reportDiagnostic(psiElement, diagnosticFactory0, string2);
                }

                public ErrorReportingVisitor(DiagnosticMessageReporter $captured_local_variable$0) {
                    this.$reporter = $captured_local_variable$0;
                    this.allErrorsAtEof = true;
                }
            }
            ErrorReportingVisitor visitor2 = new ErrorReportingVisitor(reporter);
            file2.accept(visitor2);
            return new SyntaxErrorReport(visitor2.getHasErrors(), visitor2.getAllErrorsAtEof());
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file2, @NotNull MessageCollector messageCollector) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
            return this.reportSyntaxErrors(file2, new DefaultDiagnosticReporter(messageCollector));
        }

        public final void reportBytecodeVersionErrors(@NotNull BindingContext bindingContext, @NotNull MessageCollector messageCollector) {
            Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
            CompilerMessageSeverity severity = Intrinsics.areEqual((Object)System.getProperty("kotlin.jvm.disable.bytecode.version.error"), (Object)"true") ? CompilerMessageSeverity.STRONG_WARNING : CompilerMessageSeverity.ERROR;
            Collection<String> locations = bindingContext.getKeys(IncompatibleClassTrackerImpl.BYTECODE_VERSION_ERRORS);
            if (locations.isEmpty()) {
                return;
            }
            for (String location2 : locations) {
                IncompatibleVersionErrorData data;
                if ((IncompatibleVersionErrorData)bindingContext.get(IncompatibleClassTrackerImpl.BYTECODE_VERSION_ERRORS, location2) == null) {
                    String string2 = "Value is missing for key in binding context: " + location2;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                IncompatibleVersionErrorData incompatibleVersionErrorData = data;
                Intrinsics.checkExpressionValueIsNotNull((Object)incompatibleVersionErrorData, (String)"data");
                this.reportIncompatibleBinaryVersion(messageCollector, incompatibleVersionErrorData, severity);
            }
        }

        private final void reportIncompatibleBinaryVersion(MessageCollector messageCollector, IncompatibleVersionErrorData<JvmBytecodeBinaryVersion> data, CompilerMessageSeverity severity) {
            messageCollector.report(severity, "Class '" + JvmClassName.byClassId(data.getClassId()) + "' was compiled with an incompatible version of Kotlin. " + "The binary version of its bytecode is " + data.getActualVersion() + ", expected version is " + data.getExpectedVersion(), CompilerMessageLocation.Companion.create(FileUtil.toSystemDependentName(data.getFilePath())));
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$reportDiagnostic(Companion $this, Diagnostic diagnostic, DiagnosticMessageReporter reporter) {
            return $this.reportDiagnostic(diagnostic, reporter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

