/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.kotlin.com.intellij.util.io.ByteBufferUtil;
import org.jetbrains.kotlin.com.intellij.util.io.ByteBufferWrapper;

abstract class DirectBufferWrapper
extends ByteBufferWrapper {
    private volatile ByteBuffer myBuffer;

    DirectBufferWrapper(File file2, long offset2, long length) {
        super(file2, offset2, length);
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.create();
        }
        return buffer;
    }

    protected abstract ByteBuffer create() throws IOException;

    @Override
    public void unmap() {
        if (this.isDirty()) {
            this.flush();
        }
        if (this.myBuffer != null) {
            ByteBufferUtil.cleanBuffer(this.myBuffer);
            this.myBuffer = null;
        }
    }
}

