/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.serialization.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.serialization.PropertyCollector;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.xmlb.AccessorBindingWrapper;
import org.jetbrains.kotlin.com.intellij.util.xmlb.AttributeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.CompactCollectionBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Converter;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMElementBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NestedBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NotNullDeserializeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.OptionTagBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Serializer;
import org.jetbrains.kotlin.com.intellij.util.xmlb.TagBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.TextBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.AbstractCollection;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.CollectionBean;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.MapAnnotation;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.OptionTag;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Property;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Text;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.XCollection;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.XMap;
import org.jetbrains.kotlin.org.jdom.Comment;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;

public class BeanBinding
extends NotNullDeserializeBinding {
    private static final XmlSerializerPropertyCollector PROPERTY_COLLECTOR = new XmlSerializerPropertyCollector();
    private final String myTagName;
    protected NestedBinding[] myBindings;
    protected final Class<?> myBeanClass;
    ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass) {
        if (beanClass == null) {
            BeanBinding.$$$reportNull$$$0(0);
        }
        this.compareByFields = ThreeState.UNSURE;
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public final synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        if (originalType == null) {
            BeanBinding.$$$reportNull$$$0(1);
        }
        if (serializer2 == null) {
            BeanBinding.$$$reportNull$$$0(2);
        }
        assert (this.myBindings == null);
        Property classAnnotation = this.myBeanClass.getAnnotation(Property.class);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new NestedBinding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            NestedBinding binding = BeanBinding.createBinding(accessors.get(i), serializer2, classAnnotation == null ? Property.Style.OPTION_TAG : classAnnotation.style());
            binding.init(originalType, serializer2);
            this.myBindings[i] = binding;
        }
    }

    @Override
    @NotNull
    public final Object deserialize(@Nullable Object context2, @NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(8);
        }
        Object instance = this.newInstance();
        this.deserializeInto(instance, element);
        Object object = instance;
        if (object == null) {
            BeanBinding.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    protected Object newInstance() {
        Object obj = ReflectionUtil.newInstance(this.myBeanClass, false);
        if (obj == null) {
            BeanBinding.$$$reportNull$$$0(10);
        }
        return obj;
    }

    public final void deserializeInto(@NotNull Object result2, @NotNull Element element) {
        if (result2 == null) {
            BeanBinding.$$$reportNull$$$0(17);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(18);
        }
        this.deserializeInto(result2, element, null);
    }

    public final void deserializeInto(@NotNull Object result2, @NotNull Element element, @Nullable Set<? super String> accessorNameTracker) {
        if (result2 == null) {
            BeanBinding.$$$reportNull$$$0(19);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(20);
        }
        block0: for (org.jetbrains.kotlin.org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtil.isEmpty(attribute.getNamespaceURI())) continue;
            for (NestedBinding binding : this.myBindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).myName.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result2, attribute.getValue());
                continue block0;
            }
        }
        LinkedHashMap data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (NestedBinding binding : this.myBindings) {
                if (content instanceof org.jetbrains.kotlin.org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result2, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = new LinkedHashMap();
                    }
                    ContainerUtilRt.putValue(binding, child, data);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserializeUnsafe(result2, child);
                continue block2;
            }
        }
        for (NestedBinding binding : this.myBindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat()) continue;
            ((AccessorBindingWrapper)binding).deserialize(result2, element);
        }
        if (data != null) {
            for (NestedBinding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result2, (List)data.get(binding));
            }
        }
    }

    @Override
    public final boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(21);
        }
        return element.getName().equals(this.myTagName);
    }

    @NotNull
    private static String getTagName(@NotNull Class<?> aClass2) {
        int lastIndexOf;
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(22);
        }
        for (Class<?> c = aClass2; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            String string2 = name;
            if (string2 == null) {
                BeanBinding.$$$reportNull$$$0(23);
            }
            return string2;
        }
        String name = aClass2.getSimpleName();
        if (name.isEmpty()) {
            name = aClass2.getSuperclass().getSimpleName();
        }
        if ((lastIndexOf = name.lastIndexOf(36)) > 0 && name.length() > lastIndexOf + 1) {
            String string3 = name.substring(lastIndexOf + 1);
            if (string3 == null) {
                BeanBinding.$$$reportNull$$$0(24);
            }
            return string3;
        }
        String string4 = name;
        if (string4 == null) {
            BeanBinding.$$$reportNull$$$0(25);
        }
        return string4;
    }

    @Nullable
    private static String getTagNameFromAnnotation(@NotNull Class<?> aClass2) {
        Tag tag;
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(26);
        }
        return (tag = aClass2.getAnnotation(Tag.class)) != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    public static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass2) {
        List<MutableAccessor> accessors;
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(27);
        }
        if ((accessors = PROPERTY_COLLECTOR.collect(aClass2)).isEmpty() && !BeanBinding.isAssertBindings(aClass2)) {
            LOG.warn("no accessors for " + aClass2);
        }
        List<MutableAccessor> list2 = accessors;
        if (list2 == null) {
            BeanBinding.$$$reportNull$$$0(28);
        }
        return list2;
    }

    private static boolean isAssertBindings(@NotNull Class<?> aClass2) {
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(29);
        }
        do {
            Property property2;
            if ((property2 = aClass2.getAnnotation(Property.class)) == null || property2.assertIfNoBindings()) continue;
            return true;
        } while ((aClass2 = aClass2.getSuperclass()) != null);
        return false;
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static NestedBinding createBinding(@NotNull MutableAccessor accessor, @NotNull Serializer serializer2, @NotNull Property.Style propertyStyle) {
        XMap xMap;
        Attribute attribute;
        if (accessor == null) {
            BeanBinding.$$$reportNull$$$0(30);
        }
        if (serializer2 == null) {
            BeanBinding.$$$reportNull$$$0(31);
        }
        if (propertyStyle == null) {
            BeanBinding.$$$reportNull$$$0(32);
        }
        if ((attribute = accessor.getAnnotation(Attribute.class)) != null) {
            return new AttributeBinding(accessor, attribute);
        }
        Text text2 = accessor.getAnnotation(Text.class);
        if (text2 != null) {
            return new TextBinding(accessor);
        }
        OptionTag optionTag = accessor.getAnnotation(OptionTag.class);
        if (optionTag != null && optionTag.converter() != Converter.class) {
            return new OptionTagBinding(accessor, optionTag);
        }
        Binding binding = serializer2.getBinding(accessor);
        if (binding instanceof JDOMElementBinding) {
            JDOMElementBinding jDOMElementBinding = (JDOMElementBinding)binding;
            if (jDOMElementBinding == null) {
                BeanBinding.$$$reportNull$$$0(33);
            }
            return jDOMElementBinding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            return new TagBinding(accessor, tag);
        }
        if (binding instanceof CompactCollectionBinding) {
            return new AccessorBindingWrapper(accessor, binding, false, Property.Style.OPTION_TAG);
        }
        boolean surroundWithTag = true;
        boolean inline = false;
        Property property2 = accessor.getAnnotation(Property.class);
        if (property2 != null) {
            surroundWithTag = property2.surroundWithTag();
            inline = property2.flat();
        }
        if (!surroundWithTag || inline) {
            if (inline && !(binding instanceof BeanBinding)) {
                throw new XmlSerializationException("inline supported only for BeanBinding: " + accessor);
            }
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            return new AccessorBindingWrapper(accessor, binding, inline, property2.style());
        }
        XCollection xCollection = accessor.getAnnotation(XCollection.class);
        if (!(xCollection == null || xCollection.propertyElementName().isEmpty() && xCollection.style() != XCollection.Style.v2)) {
            return new TagBinding(accessor, xCollection.propertyElementName());
        }
        if (optionTag == null && (xMap = accessor.getAnnotation(XMap.class)) != null) {
            return new TagBinding(accessor, xMap.propertyElementName());
        }
        if (propertyStyle == Property.Style.ATTRIBUTE) {
            return new AttributeBinding(accessor, null);
        }
        return new OptionTagBinding(accessor, optionTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 8: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorNameTracker";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weights";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeBindingWeights";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeInto";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializePropertyInto";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 33: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equalByFields";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeBindingWeights";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sortBindings";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deserializeInto";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTagNameFromAnnotation";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAssertBindings";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createBinding";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class XmlSerializerPropertyCollector
    extends PropertyCollector {
        private final Map<Class<?>, List<MutableAccessor>> accessorCache = ContainerUtil.newConcurrentMap();

        XmlSerializerPropertyCollector() {
            super((byte)1);
        }

        @Override
        @NotNull
        public List<MutableAccessor> collect(@NotNull Class<?> aClass2) {
            if (aClass2 == null) {
                XmlSerializerPropertyCollector.$$$reportNull$$$0(0);
            }
            List list2 = this.accessorCache.computeIfAbsent(aClass2, x$0 -> super.collect((Class<?>)x$0));
            if (list2 == null) {
                XmlSerializerPropertyCollector.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        protected boolean isAnnotatedAsTransient(@NotNull AnnotatedElement element) {
            if (element == null) {
                XmlSerializerPropertyCollector.$$$reportNull$$$0(2);
            }
            return element.isAnnotationPresent(Transient.class);
        }

        @Override
        protected boolean hasStoreAnnotations(@NotNull AccessibleObject element) {
            if (element == null) {
                XmlSerializerPropertyCollector.$$$reportNull$$$0(3);
            }
            return element.isAnnotationPresent(OptionTag.class) || element.isAnnotationPresent(Tag.class) || element.isAnnotationPresent(Attribute.class) || element.isAnnotationPresent(Property.class) || element.isAnnotationPresent(Text.class) || element.isAnnotationPresent(CollectionBean.class) || element.isAnnotationPresent(MapAnnotation.class) || element.isAnnotationPresent(XMap.class) || element.isAnnotationPresent(XCollection.class) || element.isAnnotationPresent(AbstractCollection.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding$XmlSerializerPropertyCollector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding$XmlSerializerPropertyCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collect";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAnnotatedAsTransient";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "hasStoreAnnotations";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

