/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0004H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils;", "", "()V", "computeMask", "", "hasModifier", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "", "computeMaskFromModifierList", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "maskHasModifier", "mask", "modifierToken", "maskToString", "", "psi"})
public final class ModifierMaskUtils {
    public static final ModifierMaskUtils INSTANCE;

    @JvmStatic
    public static final long computeMaskFromModifierList(@NotNull KtModifierList modifierList2) {
        Intrinsics.checkNotNullParameter((Object)modifierList2, (String)"modifierList");
        return ModifierMaskUtils.computeMask((Function1<? super KtModifierKeywordToken, Boolean>)((Function1)new Function1<KtModifierKeywordToken, Boolean>(modifierList2){
            final /* synthetic */ KtModifierList $modifierList;

            public final boolean invoke(@NotNull KtModifierKeywordToken it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$modifierList.hasModifier(it);
            }
            {
                this.$modifierList = ktModifierList;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final long computeMask(@NotNull Function1<? super KtModifierKeywordToken, Boolean> hasModifier) {
        Intrinsics.checkNotNullParameter(hasModifier, (String)"hasModifier");
        long mask = 0L;
        Intrinsics.checkNotNullExpressionValue((Object)KtTokens.MODIFIER_KEYWORDS_ARRAY, (String)"MODIFIER_KEYWORDS_ARRAY");
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
        int n = ktModifierKeywordTokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            void index2;
            KtModifierKeywordToken modifierKeywordToken;
            KtModifierKeywordToken ktModifierKeywordToken = modifierKeywordToken = ktModifierKeywordTokenArray[n2];
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"modifierKeywordToken");
            if (((Boolean)hasModifier.invoke((Object)ktModifierKeywordToken)).booleanValue()) {
                mask |= 1L << index2;
            }
            ++index2;
        }
        return mask;
    }

    @JvmStatic
    public static final boolean maskHasModifier(long mask, @NotNull KtModifierKeywordToken modifierToken) {
        Intrinsics.checkNotNullParameter((Object)modifierToken, (String)"modifierToken");
        Intrinsics.checkNotNullExpressionValue((Object)KtTokens.MODIFIER_KEYWORDS_ARRAY, (String)"MODIFIER_KEYWORDS_ARRAY");
        int index2 = ArraysKt.indexOf((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY, (Object)modifierToken);
        boolean bl = index2 >= 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "All JetModifierKeywordTokens should be present in MODIFIER_KEYWORDS_ARRAY";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return (mask & 1L << index2) != 0L;
    }

    @JvmStatic
    @NotNull
    public static final String maskToString(long mask) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
        int n = ktModifierKeywordTokenArray.length;
        for (int i = 0; i < n; ++i) {
            KtModifierKeywordToken modifierKeyword;
            KtModifierKeywordToken ktModifierKeywordToken = modifierKeyword = ktModifierKeywordTokenArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"modifierKeyword");
            if (!ModifierMaskUtils.maskHasModifier(mask, ktModifierKeywordToken)) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(modifierKeyword.getValue());
            first = false;
        }
        sb.append("]");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    private ModifierMaskUtils() {
    }

    static {
        ModifierMaskUtils modifierMaskUtils;
        INSTANCE = modifierMaskUtils = new ModifierMaskUtils();
        boolean bl = KtTokens.MODIFIER_KEYWORDS_ARRAY.length <= 64;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Current implementation depends on the ability to represent modifier list as bit mask";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }
}

