/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.multiplatform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaPropertyInitializerEvaluatorImpl;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationAsAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClassObjectAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaEnumValueAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/multiplatform/JavaActualAnnotationArgumentExtractor;", "Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "()V", "convertTypeToKClassValue", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "javaType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "extractDefaultValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "convert", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationArgument;", "frontend.java"})
public final class JavaActualAnnotationArgumentExtractor
implements ExpectedActualDeclarationChecker.ActualAnnotationArgumentExtractor {
    @Override
    @Nullable
    public ConstantValue<?> extractDefaultValue(@NotNull ValueParameterDescriptor parameter, @NotNull KotlinType expectedType2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
        SourceElement sourceElement = parameter.getSource();
        if (!(sourceElement instanceof JavaSourceElement)) {
            sourceElement = null;
        }
        JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
        JavaElement element = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
        JavaElement javaElement = element;
        if (!(javaElement instanceof JavaMethod)) {
            javaElement = null;
        }
        return (object = (JavaMethod)javaElement) != null && (object = object.getAnnotationParameterDefaultValue()) != null ? this.convert((JavaAnnotationArgument)object, expectedType2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> convert(JavaAnnotationArgument $this$convert, KotlinType expectedType2) {
        ConstantValue constantValue;
        JavaAnnotationArgument javaAnnotationArgument = $this$convert;
        if (javaAnnotationArgument instanceof JavaLiteralAnnotationArgument) {
            Object object = ((JavaLiteralAnnotationArgument)$this$convert).getValue();
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                constantValue = JavaPropertyInitializerEvaluatorImpl.INSTANCE.convertLiteralValue$frontend_java(it, expectedType2);
            } else {
                constantValue = null;
            }
        } else if (javaAnnotationArgument instanceof JavaEnumValueAnnotationArgument) {
            EnumValue enumValue;
            ClassId classId = ((JavaEnumValueAnnotationArgument)$this$convert).getEnumClassId();
            if (classId != null) {
                ClassId classId2 = classId;
                boolean bl = false;
                boolean bl4 = false;
                ClassId enumClassId = classId2;
                boolean bl5 = false;
                Name name = ((JavaEnumValueAnnotationArgument)$this$convert).getEntryName();
                if (name != null) {
                    Name name2 = name;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Name entryName = name2;
                    boolean bl8 = false;
                    enumValue = new EnumValue(enumClassId, entryName);
                } else {
                    enumValue = null;
                }
            } else {
                enumValue = null;
            }
            constantValue = enumValue;
        } else if (javaAnnotationArgument instanceof JavaArrayAnnotationArgument) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            KotlinType kotlinType = TypeUtilsKt.getBuiltIns(expectedType2).getArrayElementType(expectedType2);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType.builtIns.ge\u2026ElementType(expectedType)");
            KotlinType elementType = kotlinType;
            Iterable iterable = ((JavaArrayAnnotationArgument)$this$convert).getElements();
            ConstantValueFactory constantValueFactory = ConstantValueFactory.INSTANCE;
            boolean $i$f$mapNotNull = false;
            void enumClassId = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConstantValue<?> constantValue2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                JavaAnnotationArgument it = (JavaAnnotationArgument)element$iv$iv;
                boolean bl9 = false;
                if (this.convert(it, elementType) == null) continue;
                boolean bl10 = false;
                boolean bl11 = false;
                ConstantValue<?> it$iv$iv = constantValue2;
                boolean bl12 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            constantValue = constantValueFactory.createArrayValue(list2, expectedType2);
        } else {
            constantValue = javaAnnotationArgument instanceof JavaAnnotationAsAnnotationArgument ? null : (javaAnnotationArgument instanceof JavaClassObjectAnnotationArgument ? (ConstantValue)this.convertTypeToKClassValue(((JavaClassObjectAnnotationArgument)$this$convert).getReferencedType()) : null);
        }
        return constantValue;
    }

    private final KClassValue convertTypeToKClassValue(JavaType javaType) {
        KClassValue kClassValue;
        JavaType type2 = javaType;
        int arrayDimensions = 0;
        while (type2 instanceof JavaArrayType) {
            type2 = ((JavaArrayType)type2).getComponentType();
            ++arrayDimensions;
        }
        JavaType javaType2 = type2;
        if (javaType2 instanceof JavaPrimitiveType) {
            PrimitiveType primitiveType = ((JavaPrimitiveType)type2).getType();
            if (primitiveType == null) {
                ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"ClassId.topLevel(KotlinB\u2026s.FQ_NAMES.unit.toSafe())");
                return new KClassValue(classId, 0);
            }
            PrimitiveType primitiveType2 = primitiveType;
            if (arrayDimensions > 0) {
                ClassId classId = ClassId.topLevel(primitiveType2.getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"ClassId.topLevel(primitiveType.arrayTypeFqName)");
                kClassValue = new KClassValue(classId, arrayDimensions - 1);
            } else {
                ClassId classId = ClassId.topLevel(primitiveType2.getTypeFqName());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"ClassId.topLevel(primitiveType.typeFqName)");
                kClassValue = new KClassValue(classId, arrayDimensions);
            }
        } else if (javaType2 instanceof JavaClassifierType) {
            FqName fqName2 = new FqName(((JavaClassifierType)type2).getClassifierQualifiedName());
            ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
            if (classId == null) {
                ClassId classId2 = ClassId.topLevel(fqName2);
                classId = classId2;
                Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"ClassId.topLevel(fqName)");
            }
            ClassId classId3 = classId;
            kClassValue = new KClassValue(classId3, arrayDimensions);
        } else {
            kClassValue = null;
        }
        return kClassValue;
    }
}

