/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.storage.DefaultSimpleLock;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0005\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/storage/CancellableSimpleLock;", "Lorg/jetbrains/kotlin/storage/DefaultSimpleLock;", "checkCancelled", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "lock", "Ljava/util/concurrent/locks/Lock;", "(Ljava/util/concurrent/locks/Lock;Ljava/lang/Runnable;)V", "", "util.runtime"})
public final class CancellableSimpleLock
extends DefaultSimpleLock {
    private final Runnable checkCancelled;

    @Override
    public void lock() {
        while (!this.getLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
            this.checkCancelled.run();
        }
    }

    public CancellableSimpleLock(@NotNull Lock lock, @NotNull Runnable checkCancelled) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        super(lock);
        this.checkCancelled = checkCancelled;
    }

    public CancellableSimpleLock(@NotNull Runnable checkCancelled) {
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        Lock lock = new ReentrantLock();
        Runnable runnable = checkCancelled;
        this(lock, runnable);
    }
}

