/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public final class PsiLiteralUtil {
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);

    @Nullable
    public static Integer parseInteger(String text2) {
        try {
            if (text2.startsWith(HEX_PREFIX)) {
                long value2 = PsiLiteralUtil.parseDigits(text2.substring(2), 4, 32);
                return (int)value2;
            }
            if (text2.startsWith(BIN_PREFIX)) {
                long value3 = PsiLiteralUtil.parseDigits(text2.substring(2), 1, 32);
                return (int)value3;
            }
            if (StringUtil.startsWithChar(text2, '0')) {
                long value4 = PsiLiteralUtil.parseDigits(text2, 3, 32);
                return (int)value4;
            }
            return PsiLiteralUtil.parseIntegerNoPrefix(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Integer parseIntegerNoPrefix(String text2) {
        long l = Long.parseLong(text2, 10);
        if (text2.equals(_2_IN_31) || l == (long)((int)l)) {
            return (int)l;
        }
        return null;
    }

    @Nullable
    public static Long parseLong(String text2) {
        if (StringUtil.endsWithChar(text2, 'L') || StringUtil.endsWithChar(text2, 'l')) {
            text2 = text2.substring(0, text2.length() - 1);
        }
        try {
            if (text2.startsWith(HEX_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text2.substring(2), 4, 64);
            }
            if (text2.startsWith(BIN_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text2.substring(2), 1, 64);
            }
            if (StringUtil.startsWithChar(text2, '0')) {
                return PsiLiteralUtil.parseDigits(text2, 3, 64);
            }
            if (_2_IN_63.equals(text2)) {
                return Long.MIN_VALUE;
            }
            return Long.valueOf(text2, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Float parseFloat(String text2) {
        try {
            return Float.valueOf(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double parseDouble(String text2) {
        try {
            return Double.valueOf(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long parseDigits(String text2, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text2.length();
        if (textLength == 0) {
            throw new NumberFormatException(text2);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text2.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text2);
        }
        int lastDigit = Character.digit(text2.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text2);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    @NotNull
    public static String stringForCharLiteral(@NotNull String charLiteral) {
        if (charLiteral == null) {
            PsiLiteralUtil.$$$reportNull$$$0(0);
        }
        if ("'\"'".equals(charLiteral)) {
            return "\"\\\"\"";
        }
        if ("'\\''".equals(charLiteral)) {
            return "\"'\"";
        }
        String string2 = '\"' + charLiteral.substring(1, charLiteral.length() - 1) + '\"';
        if (string2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static String charLiteralForCharString(@NotNull String text2) {
        int length;
        if (text2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(2);
        }
        if ((length = text2.length()) <= 1) {
            String string2 = text2;
            if (string2 == null) {
                PsiLiteralUtil.$$$reportNull$$$0(3);
            }
            return string2;
        }
        String character = text2.substring(1, length - 1);
        String charLiteral = "'".equals(character) ? "'\\''" : ("\\\"".equals(character) ? "'\"'" : '\'' + character + '\'');
        String string3 = charLiteral;
        if (string3 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(4);
        }
        return string3;
    }

    public static boolean isUnsafeLiteral(PsiLiteralExpression expression2) {
        PsiElement literal = expression2.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type2 = ((PsiJavaToken)literal).getTokenType();
        return (type2 == JavaTokenType.CHARACTER_LITERAL || type2 == JavaTokenType.STRING_LITERAL || type2 == JavaTokenType.TEXT_BLOCK_LITERAL) && expression2.getValue() == null;
    }

    @NotNull
    public static String escapeTextBlockCharacters(@NotNull String s) {
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(5);
        }
        return PsiLiteralUtil.escapeTextBlockCharacters(s, false, true, true);
    }

    @NotNull
    public static String escapeTextBlockCharacters(@NotNull String s, boolean escapeStartQuote, boolean escapeEndQuote, boolean escapeSpacesInTheEnd) {
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(6);
        }
        int i = 0;
        int length = s.length();
        StringBuilder result2 = new StringBuilder(length);
        while (i < length) {
            int nextIdx = PsiLiteralUtil.parseQuotes(i, s, result2, escapeStartQuote, escapeEndQuote);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            nextIdx = PsiLiteralUtil.parseSpaces(i, s, result2, escapeSpacesInTheEnd);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            nextIdx = PsiLiteralUtil.parseBackSlashes(i, s, result2);
            if (nextIdx != -1) {
                i = nextIdx;
                continue;
            }
            result2.append(s.charAt(i));
            ++i;
        }
        String string2 = result2.toString();
        if (string2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static int parseQuotes(int start, @NotNull String s, @NotNull StringBuilder result2, boolean escapeStartQuote, boolean escapeEndQuote) {
        char c;
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(9);
        }
        if ((c = s.charAt(start)) != '\"') {
            return -1;
        }
        int nQuotes = 1;
        int i = start;
        while (true) {
            int nextIdx;
            int n = nextIdx = i + 1 >= s.length() ? -1 : PsiLiteralUtil.parseBackSlash(s, i + 1);
            if (nextIdx == -1) {
                nextIdx = i + 1;
            }
            if (nextIdx >= s.length() || s.charAt(nextIdx) != '\"') break;
            ++nQuotes;
            i = nextIdx;
        }
        for (int q = 0; q < nQuotes; ++q) {
            if (q == 0 && start == 0 && escapeStartQuote || q % 3 == 2 || q == nQuotes - 1 && i + 1 == s.length() && escapeEndQuote) {
                result2.append("\\\"");
                continue;
            }
            result2.append('\"');
        }
        return i + 1;
    }

    private static int parseSpaces(int start, @NotNull String s, @NotNull StringBuilder result2, boolean escapeSpacesInTheEnd) {
        int nextIdx;
        int i;
        char c;
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(11);
        }
        if ((c = s.charAt(start)) != ' ') {
            return -1;
        }
        int nSpaces = 0;
        for (i = start; i < s.length() && s.charAt(i) == ' '; ++i) {
            ++nSpaces;
        }
        if (i >= s.length() && escapeSpacesInTheEnd) {
            result2.append(StringUtil.repeat(" ", nSpaces - 1)).append("\\s");
            return i;
        }
        int n = nextIdx = i >= s.length() ? -1 : PsiLiteralUtil.parseBackSlash(s, i);
        if (nextIdx != -1 && nextIdx < s.length() && s.charAt(nextIdx) == 'n') {
            result2.append(StringUtil.repeat(" ", nSpaces - 1)).append("\\s");
            return i;
        }
        result2.append(StringUtil.repeatSymbol(' ', nSpaces));
        return i;
    }

    private static int parseBackSlashes(int start, @NotNull String s, @NotNull StringBuilder result2) {
        int nextIdx;
        int i;
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(13);
        }
        if ((i = PsiLiteralUtil.parseBackSlash(s, start)) == -1) {
            return -1;
        }
        int prev = start;
        int nSlashes = 1;
        while (i < s.length() && (nextIdx = PsiLiteralUtil.parseBackSlash(s, i)) != -1) {
            result2.append(s, prev, i);
            prev = i;
            i = nextIdx;
            ++nSlashes;
        }
        if (i >= s.length()) {
            result2.append(s, prev, s.length());
        } else if (nSlashes % 2 == 0) {
            result2.append(s, prev, i);
        } else {
            char next = s.charAt(i);
            if (next == 'n') {
                result2.append('\n');
            } else {
                if (next == '\"') {
                    return i;
                }
                result2.append(s, prev, i).append(next);
            }
            return i + 1;
        }
        return i;
    }

    @NotNull
    public static String escapeBackSlashesInTextBlock(@NotNull String str) {
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(14);
        }
        int i = 0;
        int length = str.length();
        StringBuilder result2 = new StringBuilder(length);
        while (i < length) {
            int nextIdx = PsiLiteralUtil.parseBackSlash(str, i);
            if (nextIdx != -1) {
                result2.append("\\\\");
                i = nextIdx;
                continue;
            }
            result2.append(str.charAt(i));
            ++i;
        }
        String string2 = result2.toString();
        if (string2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(15);
        }
        return string2;
    }

    public static int parseBackSlash(@NotNull String str, int idx) {
        char c;
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(16);
        }
        if ((c = str.charAt(idx)) != '\\') {
            return -1;
        }
        int nextIdx = PsiLiteralUtil.parseEscapedBackSlash(str, idx);
        return nextIdx > 0 ? nextIdx : idx + 1;
    }

    private static int parseEscapedBackSlash(@NotNull String str, int idx) {
        int len;
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(17);
        }
        if (++idx >= (len = str.length()) || str.charAt(idx) != 'u') {
            return -1;
        }
        while (++idx < len && str.charAt(idx) == 'u') {
        }
        if (idx + 3 >= len) {
            return -1;
        }
        try {
            int code = Integer.parseInt(str.substring(idx, idx + 4), 16);
            if (code == 92) {
                return idx + 4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static String @Nullable [] getTextBlockLines(PsiLiteralExpression expression2) {
        char c;
        if (!expression2.isTextBlock()) {
            return null;
        }
        String rawText = expression2.getText();
        if (rawText.length() < 7 || !rawText.endsWith("\"\"\"")) {
            return null;
        }
        int start = 3;
        while ((c = rawText.charAt(start++)) != '\n') {
            if (Character.isWhitespace(c) && start != rawText.length()) continue;
            return null;
        }
        return rawText.substring(start, rawText.length() - 3).split("\n", -1);
    }

    public static int getTextBlockIndent(PsiLiteralExpression expression2) {
        String[] lines = PsiLiteralUtil.getTextBlockLines(expression2);
        if (lines == null) {
            return -1;
        }
        return PsiLiteralUtil.getTextBlockIndent(lines);
    }

    public static int getTextBlockIndent(String @NotNull [] lines) {
        if (lines == null) {
            PsiLiteralUtil.$$$reportNull$$$0(18);
        }
        return PsiLiteralUtil.getTextBlockIndent(lines, false, false);
    }

    public static int getTextBlockIndent(String @NotNull [] lines, boolean preserveContent, boolean ignoreLastLine) {
        if (lines == null) {
            PsiLiteralUtil.$$$reportNull$$$0(19);
        }
        int prefix = Integer.MAX_VALUE;
        for (int i = 0; i < lines.length && prefix != 0; ++i) {
            int indent;
            String line = lines[i];
            for (indent = 0; indent < line.length() && Character.isWhitespace(line.charAt(indent)); ++indent) {
            }
            if (indent == line.length() && (i < lines.length - 1 || ignoreLastLine)) {
                if (preserveContent) continue;
                lines[i] = "";
                continue;
            }
            if (indent >= prefix) continue;
            prefix = indent;
        }
        return prefix;
    }

    @Nullable
    public static String getStringLiteralContent(PsiLiteralExpression expression2) {
        String text2 = expression2.getText();
        int textLength = text2.length();
        if (textLength > 1 && text2.charAt(0) == '\"' && text2.charAt(textLength - 1) == '\"') {
            return text2.substring(1, textLength - 1);
        }
        if (textLength > "&quot;".length() && text2.startsWith("&quot;") && text2.endsWith("&quot;")) {
            return text2.substring("&quot;".length(), textLength - "&quot;".length());
        }
        return null;
    }

    @Nullable
    public static String getTextBlockText(PsiLiteralExpression expression2) {
        String[] lines = PsiLiteralUtil.getTextBlockLines(expression2);
        if (lines == null) {
            return null;
        }
        int prefix = PsiLiteralUtil.getTextBlockIndent(lines);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() > 0) {
                sb.append(PsiLiteralUtil.trimTrailingWhitespaces(line.substring(prefix)));
            }
            if (i >= lines.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @NotNull
    private static String trimTrailingWhitespaces(@NotNull String line) {
        int wsIndex;
        if (line == null) {
            PsiLiteralUtil.$$$reportNull$$$0(20);
        }
        int index2 = line.length();
        while ((wsIndex = PsiLiteralUtil.parseWhitespaceBackwards(line, index2 - 1)) != -1) {
            index2 = wsIndex;
        }
        String string2 = line.substring(0, index2);
        if (string2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(21);
        }
        return string2;
    }

    private static int parseWhitespaceBackwards(@NotNull String s, int index2) {
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(22);
        }
        if (index2 < 0) {
            return -1;
        }
        if (Character.isWhitespace(s.charAt(index2))) {
            return index2;
        }
        if ((index2 = PsiLiteralUtil.parseUnicodeEscapeBackwards(s, index2, Character::isWhitespace)) < 0) {
            return -1;
        }
        int nBackSlashes = 1;
        if (--index2 >= 0 && s.charAt(index2) == '\\') {
            ++nBackSlashes;
            nBackSlashes += PsiLiteralUtil.countBackSlashes(s, index2 - 1);
        }
        return nBackSlashes % 2 == 0 ? -1 : index2 + 1;
    }

    private static int countBackSlashes(@NotNull String s, int index2) {
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(23);
        }
        int nBackSlashes = 0;
        while (index2 >= 0) {
            int start;
            int n = start = s.charAt(index2) == '\\' ? index2 : PsiLiteralUtil.parseUnicodeEscapeBackwards(s, index2, c -> c.charValue() == '\\');
            if (start == -1) break;
            ++nBackSlashes;
            index2 = start - 1;
        }
        return nBackSlashes;
    }

    private static int parseUnicodeEscapeBackwards(@NotNull String s, int index2, @NotNull Predicate<Character> charPredicate) {
        if (s == null) {
            PsiLiteralUtil.$$$reportNull$$$0(24);
        }
        if (charPredicate == null) {
            PsiLiteralUtil.$$$reportNull$$$0(25);
        }
        if (index2 - 5 < 0) {
            return -1;
        }
        try {
            int code = Integer.parseInt(s.substring(index2 - 3, index2 + 1), 16);
            if (!charPredicate.test(Character.valueOf((char)code))) {
                return -1;
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (s.charAt(index2 - 4) != 'u') {
            return -1;
        }
        index2 -= 4;
        while (--index2 >= 0 && s.charAt(index2) == 'u') {
        }
        if (index2 < 0 || s.charAt(index2) != '\\') {
            return -1;
        }
        return index2;
    }

    @Nullable
    public static TextRange mapBackStringRange(@NotNull String text2, int from2, int to) {
        if (text2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(26);
        }
        if (from2 > to || to < 0) {
            return null;
        }
        if (text2.length() < 2 || !text2.startsWith("\"") || !text2.endsWith("\"")) {
            return null;
        }
        if (text2.indexOf(92) == -1) {
            return new TextRange(from2 + 1, to + 1);
        }
        text2 = text2.substring(1, text2.length() - 1);
        int charsSoFar = 0;
        int mappedFrom = -1;
        int i = 0;
        while (i != -1) {
            if (charsSoFar == from2) {
                mappedFrom = i;
            }
            if (charsSoFar == to) {
                return new TextRange(mappedFrom + 1, i + 1);
            }
            ++charsSoFar;
            i = PsiLiteralUtil.getCharEndIndex(text2, i);
        }
        return null;
    }

    @Nullable
    public static TextRange mapBackTextBlockRange(@NotNull String text2, int from2, int to, int indent) {
        if (text2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(27);
        }
        if (from2 > to || to < 0) {
            return null;
        }
        TextBlockModel model = TextBlockModel.create(text2, indent);
        if (model == null) {
            return null;
        }
        return model.mapTextBlockRangeBack(from2, to);
    }

    private static int getCharEndIndex(@NotNull String line, int i) {
        char c;
        if (line == null) {
            PsiLiteralUtil.$$$reportNull$$$0(28);
        }
        if (i >= line.length()) {
            return -1;
        }
        if ((c = line.charAt(i++)) == '\\') {
            char c1;
            if ((c1 = line.charAt(i++)) == 'u') {
                while (i < line.length() && line.charAt(i) == 'u') {
                    ++i;
                }
                i += 4;
            } else if (c1 >= '0' && c1 <= '7') {
                char c2;
                char c3 = c2 = i < line.length() ? line.charAt(i) : (char)'\u0000';
                if (c2 >= '0' && c2 <= '7') {
                    char c32;
                    char c4 = c32 = ++i < line.length() ? line.charAt(i) : (char)'\u0000';
                    if (c32 >= '0' && c32 <= '7' && c1 <= '3') {
                        ++i;
                    }
                }
            }
        }
        return i;
    }

    @Nullable
    public static String tryConvertNumericLiteral(@NotNull PsiLiteralExpression literal, PsiType wantedType) {
        String text2;
        Number value2;
        String text3;
        PsiType exprType;
        if (literal == null) {
            PsiLiteralUtil.$$$reportNull$$$0(29);
        }
        if (PsiType.INT.equals(exprType = literal.getType())) {
            if (PsiType.LONG.equals(wantedType)) {
                return literal.getText() + "L";
            }
            if (PsiType.FLOAT.equals(wantedType) && !(text3 = literal.getText()).startsWith("0")) {
                return text3 + "F";
            }
            if (PsiType.DOUBLE.equals(wantedType) && !(text3 = literal.getText()).startsWith("0")) {
                return text3 + ".0";
            }
        }
        if (PsiType.LONG.equals(exprType) && PsiType.INT.equals(wantedType) && (value2 = ObjectUtils.tryCast(literal.getValue(), Long.class)) != null && (Long)value2 >= Integer.MIN_VALUE && (Long)value2 <= Integer.MAX_VALUE && StringUtil.endsWithIgnoreCase(text2 = literal.getText(), "L")) {
            return text2.substring(0, text2.length() - 1);
        }
        if (PsiType.DOUBLE.equals(exprType) && PsiType.FLOAT.equals(wantedType) && (value2 = ObjectUtils.tryCast(literal.getValue(), Double.class)) != null && (double)((float)((Double)value2).doubleValue()) == (Double)value2) {
            text2 = literal.getText();
            if (StringUtil.endsWithIgnoreCase(text2, "D")) {
                text2 = text2.substring(0, text2.length() - 1);
            }
            return text2 + "F";
        }
        if (PsiType.FLOAT.equals(exprType) && PsiType.DOUBLE.equals(wantedType) && StringUtil.endsWithIgnoreCase(text3 = literal.getText(), "F")) {
            String newLiteral = text3.substring(0, text3.length() - 1);
            if (!StringUtil.containsAnyChar(newLiteral, ".eEpP")) {
                newLiteral = newLiteral + ".0";
            }
            return newLiteral;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charLiteral";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiLiteralUtil";
                break;
            }
            case 2: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charPredicate";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiLiteralUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "stringForCharLiteral";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "charLiteralForCharString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTextBlockCharacters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeBackSlashesInTextBlock";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailingWhitespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringForCharLiteral";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "charLiteralForCharString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "escapeTextBlockCharacters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseQuotes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseSpaces";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseBackSlashes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashesInTextBlock";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseBackSlash";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseEscapedBackSlash";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTextBlockIndent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailingWhitespaces";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseWhitespaceBackwards";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "countBackSlashes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseUnicodeEscapeBackwards";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mapBackStringRange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mapBackTextBlockRange";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCharEndIndex";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryConvertNumericLiteral";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TextBlockModel {
        private final String[] lines;
        private final int indent;
        private final int startPrefixLength;

        private TextBlockModel(String[] lines, int indent, int startPrefixLength) {
            this.lines = lines;
            this.indent = indent;
            this.startPrefixLength = startPrefixLength;
        }

        @Nullable
        private TextRange mapTextBlockRangeBack(int from2, int to) {
            int curOffset = this.startPrefixLength;
            int charsSoFar = 0;
            int mappedFrom = -1;
            for (int i = 0; i < this.lines.length; ++i) {
                String line = this.lines[i];
                int linePrefixLength = TextBlockModel.findLinePrefixLength(line, this.indent);
                line = line.substring(linePrefixLength);
                boolean isLastLine = i == this.lines.length - 1;
                int lineSuffixLength = TextBlockModel.findLineSuffixLength(line, isLastLine);
                line = line.substring(0, line.length() - lineSuffixLength);
                if (!isLastLine) {
                    line = line + '\n';
                }
                curOffset += linePrefixLength;
                int nextIdx = 0;
                while (true) {
                    if (from2 == charsSoFar) {
                        mappedFrom = curOffset + nextIdx;
                    }
                    if (to == charsSoFar) {
                        return new TextRange(mappedFrom, curOffset + nextIdx);
                    }
                    int charIdx = nextIdx;
                    if ((nextIdx = PsiLiteralUtil.getCharEndIndex(line, charIdx)) == -1) break;
                    ++charsSoFar;
                    if (nextIdx != line.length()) continue;
                    curOffset += lineSuffixLength;
                }
                curOffset += line.length();
            }
            return null;
        }

        private static int findLinePrefixLength(@NotNull String line, int indent) {
            boolean isBlankLine;
            if (line == null) {
                TextBlockModel.$$$reportNull$$$0(0);
            }
            return (isBlankLine = line.chars().allMatch(Character::isWhitespace)) ? line.length() : indent;
        }

        private static int findLineSuffixLength(@NotNull String line, boolean isLastLine) {
            int lastIdx;
            if (line == null) {
                TextBlockModel.$$$reportNull$$$0(1);
            }
            if (isLastLine) {
                return 0;
            }
            for (int i = lastIdx = line.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                return lastIdx - i;
            }
            return 0;
        }

        @Nullable
        private static TextBlockModel create(@NotNull String text2, int indent) {
            if (text2 == null) {
                TextBlockModel.$$$reportNull$$$0(2);
            }
            if (text2.length() < 7 || !text2.startsWith("\"\"\"") || !text2.endsWith("\"\"\"")) {
                return null;
            }
            int startPrefixLength = TextBlockModel.findStartPrefixLength(text2);
            if (startPrefixLength == -1) {
                return null;
            }
            String[] lines = text2.substring(startPrefixLength, text2.length() - 3).split("\n", -1);
            return new TextBlockModel(lines, indent, startPrefixLength);
        }

        @Contract(pure=true)
        private static int findStartPrefixLength(@NotNull String text2) {
            int lineBreakIdx;
            if (text2 == null) {
                TextBlockModel.$$$reportNull$$$0(3);
            }
            if ((lineBreakIdx = text2.indexOf("\n")) == -1) {
                return -1;
            }
            return lineBreakIdx + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiLiteralUtil$TextBlockModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findLinePrefixLength";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findLineSuffixLength";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findStartPrefixLength";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

