/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.utils;

import java.io.File;

public class OSUtils {
    public static final boolean IS_WINDOWS;
    public static final boolean IS_CYGWIN;
    public static final boolean IS_MINGW;
    public static final boolean IS_OSX;
    public static String TTY_COMMAND;
    public static String STTY_COMMAND;
    public static String STTY_F_OPTION;
    public static String INFOCMP_COMMAND;

    static {
        String infocmp;
        String sttyfopt;
        String stty;
        String tty;
        IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");
        IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
        IS_MINGW = IS_WINDOWS && System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW");
        IS_OSX = System.getProperty("os.name").toLowerCase().contains("mac");
        if (IS_CYGWIN || IS_MINGW) {
            tty = "tty.exe";
            stty = "stty.exe";
            sttyfopt = null;
            infocmp = "infocmp.exe";
            String path2 = System.getenv("PATH");
            if (path2 != null) {
                String[] paths;
                for (String p : paths = path2.split(";")) {
                    if (new File(p, "tty.exe").exists()) {
                        tty = new File(p, "tty.exe").getAbsolutePath();
                    }
                    if (new File(p, "stty.exe").exists()) {
                        stty = new File(p, "stty.exe").getAbsolutePath();
                    }
                    if (!new File(p, "infocmp.exe").exists()) continue;
                    infocmp = new File(p, "infocmp.exe").getAbsolutePath();
                }
            }
        } else {
            tty = "tty";
            stty = "stty";
            infocmp = "infocmp";
            sttyfopt = IS_OSX ? "-f" : "-F";
        }
        TTY_COMMAND = tty;
        STTY_COMMAND = stty;
        STTY_F_OPTION = sttyfopt;
        INFOCMP_COMMAND = infocmp;
    }
}

