/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.NavigatablePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElementList;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocCommentOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstantInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaDocumentedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiLoopStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMirrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceListElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabelStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.ServerPageFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.ThreadLocalTypes;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightClassReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PackageScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaPsiPatternUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PairFunction;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public final class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance(PsiImplUtil.class);
    private static final Key<Boolean> TYPE_ANNO_MARK = Key.create("type.annotation.mark");

    private PsiImplUtil() {
    }

    public static PsiMethod @NotNull [] getConstructors(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiImplUtil.$$$reportNull$$$0(0);
        }
        SmartList<PsiMethod> result2 = null;
        for (PsiMethod method : aClass.getMethods()) {
            if (!method.isConstructor() || !method.getName().equals(aClass.getName())) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiMethod>();
            }
            result2.add(method);
        }
        PsiMethod[] psiMethodArray = result2 == null ? PsiMethod.EMPTY_ARRAY : result2.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiImplUtil.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiAnnotationMemberValue findDeclaredAttributeValue(@NotNull PsiAnnotation annotation, @NonNls @Nullable String attributeName) {
        PsiNameValuePair attribute;
        if (annotation == null) {
            PsiImplUtil.$$$reportNull$$$0(2);
        }
        return (attribute = AnnotationUtil.findDeclaredAttribute(annotation, attributeName)) == null ? null : attribute.getValue();
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiAnnotation annotation, @Nullable @NonNls String attributeName) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotationMemberValue value2;
        if (annotation == null) {
            PsiImplUtil.$$$reportNull$$$0(3);
        }
        if ((value2 = PsiImplUtil.findDeclaredAttributeValue(annotation, attributeName)) != null) {
            return value2;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods2;
            for (PsiMethod method : methods2 = ((PsiClass)resolved).findMethodsByName(attributeName, false)) {
                if (!PsiUtil.isAnnotationMethod(method)) continue;
                return ((PsiAnnotationMethod)method).getDefaultValue();
            }
        }
        return null;
    }

    public static PsiTypeParameter @NotNull [] getTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameterList typeParameterList;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(4);
        }
        if ((typeParameterList = owner.getTypeParameterList()) != null) {
            PsiTypeParameter[] psiTypeParameterArray = typeParameterList.getTypeParameters();
            if (psiTypeParameterArray == null) {
                PsiImplUtil.$$$reportNull$$$0(5);
            }
            return psiTypeParameterArray;
        }
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            PsiImplUtil.$$$reportNull$$$0(6);
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    public static PsiJavaCodeReferenceElement @NotNull [] namesToPackageReferences(@NotNull PsiManager manager, String @NotNull [] names) {
        if (manager == null) {
            PsiImplUtil.$$$reportNull$$$0(7);
        }
        if (names == null) {
            PsiImplUtil.$$$reportNull$$$0(8);
        }
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name2 = names[i];
            try {
                refs[i] = JavaPsiFacade.getElementFactory(manager.getProject()).createPackageReferenceElement(name2);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
        if (refs == null) {
            PsiImplUtil.$$$reportNull$$$0(9);
        }
        return refs;
    }

    public static int getParameterIndex(@NotNull PsiParameter parameter, @NotNull PsiParameterList parameterList2) {
        int i;
        if (parameter == null) {
            PsiImplUtil.$$$reportNull$$$0(10);
        }
        if (parameterList2 == null) {
            PsiImplUtil.$$$reportNull$$$0(11);
        }
        PsiElement parameterParent = parameter.getParent();
        assert (parameterParent == parameterList2) : parameterList2 + "; " + parameterParent;
        PsiParameter[] parameters = parameterList2.getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiParameter paramInList = parameters[i2];
            if (!parameter.equals(paramInList)) continue;
            return i2;
        }
        String name2 = parameter.getName();
        PsiParameter suspect = null;
        for (i = parameters.length - 1; i >= 0; --i) {
            PsiParameter paramInList = parameters[i];
            if (!Objects.equals(name2, paramInList.getName())) continue;
            suspect = paramInList;
            break;
        }
        String message = parameter + ":" + parameter.getClass() + " not found among parameters: " + Arrays.asList(parameters) + ". parameterList' parent: " + parameterList2.getParent() + "; parameter.isValid()=" + parameter.isValid() + "; parameterList.isValid()= " + parameterList2.isValid() + "; parameterList stub: " + (parameterList2 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)parameterList2)).getStub() : "---") + ";  parameter stub: " + (parameter instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)parameter)).getStub() : "---") + "; suspect: " + suspect + " (index=" + i + "); " + (suspect == null ? null : suspect.getClass()) + " suspect stub: " + (suspect instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)suspect)).getStub() : (suspect == null ? "-null-" : "---" + suspect.getClass())) + "; parameter.equals(suspect) = " + parameter.equals(suspect) + ";  parameter.getNode() == suspect.getNode():  " + (parameter.getNode() == (suspect == null ? null : suspect.getNode())) + "; .";
        LOG.error(message);
        return i;
    }

    public static int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter, @NotNull PsiTypeParameterList typeParameterList) {
        if (typeParameter == null) {
            PsiImplUtil.$$$reportNull$$$0(12);
        }
        if (typeParameterList == null) {
            PsiImplUtil.$$$reportNull$$$0(13);
        }
        PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameter.equals(typeParameters[i])) continue;
            return i;
        }
        LOG.error(typeParameter + " in " + typeParameterList);
        return -1;
    }

    public static Object @NotNull [] getReferenceVariantsByFilter(@NotNull PsiJavaCodeReferenceElement reference2, @NotNull ElementFilter filter) {
        if (reference2 == null) {
            PsiImplUtil.$$$reportNull$$$0(14);
        }
        if (filter == null) {
            PsiImplUtil.$$$reportNull$$$0(15);
        }
        FilterScopeProcessor processor = new FilterScopeProcessor(filter);
        PsiScopesUtil.resolveAndWalk(processor, reference2, null, true);
        Object[] objectArray = processor.getResults().toArray();
        if (objectArray == null) {
            PsiImplUtil.$$$reportNull$$$0(16);
        }
        return objectArray;
    }

    public static boolean processDeclarationsInMethod(@NotNull PsiMethod method, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (method == null) {
            PsiImplUtil.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(18);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(19);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(20);
        }
        if (lastParent instanceof DummyHolder) {
            lastParent = lastParent.getFirstChild();
        }
        boolean fromBody = lastParent instanceof PsiCodeBlock;
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        return PsiImplUtil.processDeclarationsInMethodLike(method, processor, state, place, fromBody, typeParameterList);
    }

    public static boolean processDeclarationsInLambda(@NotNull PsiLambdaExpression lambda2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement firstChild;
        if (lambda2 == null) {
            PsiImplUtil.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(22);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(23);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(24);
        }
        boolean fromBody = lastParent instanceof DummyHolder ? (firstChild = lastParent.getFirstChild()) instanceof PsiExpression || firstChild instanceof PsiCodeBlock : lastParent != null && lastParent == lambda2.getBody();
        return PsiImplUtil.processDeclarationsInMethodLike(lambda2, processor, state, place, fromBody, null);
    }

    private static boolean processDeclarationsInMethodLike(@NotNull PsiParameterListOwner element, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean fromBody, @Nullable PsiTypeParameterList typeParameterList) {
        ElementClassHint hint;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(26);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(27);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(28);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, element);
        if (typeParameterList != null && ((hint = processor.getHint(ElementClassHint.KEY)) == null || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && !typeParameterList.processDeclarations(processor, state, null, place)) {
            return false;
        }
        if (fromBody) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = element.getParameterList().getParameters()) {
                if (processor.execute(parameter, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInResourceList(@NotNull PsiResourceList resourceList, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent) {
        PsiResourceListElement resource;
        ElementClassHint hint;
        if (resourceList == null) {
            PsiImplUtil.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(30);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(31);
        }
        if ((hint = processor.getHint(ElementClassHint.KEY)) != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        Iterator iterator2 = resourceList.iterator();
        while (iterator2.hasNext() && (resource = (PsiResourceListElement)iterator2.next()) != lastParent) {
            if (!(resource instanceof PsiResourceVariable) || processor.execute(resource, state)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameterList typeParameterList;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(32);
        }
        return (typeParameterList = owner.getTypeParameterList()) != null && typeParameterList.getTypeParameters().length != 0;
    }

    public static PsiType @NotNull [] typesByReferenceParameterList(@NotNull PsiReferenceParameterList parameterList2) {
        if (parameterList2 == null) {
            PsiImplUtil.$$$reportNull$$$0(33);
        }
        PsiTypeElement[] typeElements = parameterList2.getTypeParameterElements();
        return PsiImplUtil.typesByTypeElements(typeElements);
    }

    public static PsiType @NotNull [] typesByTypeElements(PsiTypeElement @NotNull [] typeElements) {
        if (typeElements == null) {
            PsiImplUtil.$$$reportNull$$$0(34);
        }
        PsiType[] types2 = PsiType.createArray(typeElements.length);
        for (int i = 0; i < types2.length; ++i) {
            types2[i] = typeElements[i].getType();
        }
        if (types2.length == 1 && types2[0] instanceof PsiDiamondType) {
            PsiType[] psiTypeArray = ((PsiDiamondType)types2[0]).resolveInferredTypes().getTypes();
            if (psiTypeArray == null) {
                PsiImplUtil.$$$reportNull$$$0(35);
            }
            return psiTypeArray;
        }
        if (types2 == null) {
            PsiImplUtil.$$$reportNull$$$0(36);
        }
        return types2;
    }

    @NotNull
    public static PsiType getType(@NotNull PsiClassObjectAccessExpression classAccessExpression) {
        PsiTypeParameter[] typeParameters;
        if (classAccessExpression == null) {
            PsiImplUtil.$$$reportNull$$$0(37);
        }
        GlobalSearchScope resolveScope = classAccessExpression.getResolveScope();
        PsiManager manager = classAccessExpression.getManager();
        PsiClass classClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Class", resolveScope);
        if (classClass == null) {
            return new PsiClassReferenceType(new LightClassReference(manager, "Class", "java.lang.Class", resolveScope), null);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(classAccessExpression)) {
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory(manager.getProject()).createType(classClass);
            if (psiClassType == null) {
                PsiImplUtil.$$$reportNull$$$0(38);
            }
            return psiClassType;
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        PsiType operandType = classAccessExpression.getOperand().getType();
        if (operandType instanceof PsiPrimitiveType && !PsiType.NULL.equals(operandType)) {
            operandType = PsiType.VOID.equals(operandType) ? JavaPsiFacade.getElementFactory(manager.getProject()).createTypeByFQClassName("java.lang.Void", classAccessExpression.getResolveScope()) : ((PsiPrimitiveType)operandType).getBoxedType(classAccessExpression);
        }
        if ((typeParameters = classClass.getTypeParameters()).length == 1) {
            substitutor2 = substitutor2.put(typeParameters[0], operandType instanceof PsiClassType ? ((PsiClassType)operandType).rawType() : operandType);
        }
        return new PsiImmediateClassType(classClass, substitutor2);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiAnnotationOwner annotationOwner, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiImplUtil.$$$reportNull$$$0(39);
        }
        if (annotationOwner == null) {
            return null;
        }
        PsiAnnotation[] annotations2 = annotationOwner.getAnnotations();
        if (annotations2.length == 0) {
            return null;
        }
        String shortName = StringUtil.getShortName(qualifiedName);
        for (PsiAnnotation annotation : annotations2) {
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement == null || !shortName.equals(referenceElement.getReferenceName()) || !qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static ASTNode findDocComment(@NotNull CompositeElement element) {
        TreeElement node;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(40);
        }
        for (node = element.getFirstChildNode(); node != null && PsiImplUtil.isWhitespaceOrComment(node) && !(node.getPsi() instanceof PsiDocComment); node = node.getTreeNext()) {
        }
        return node == null || node.getElementType() != JavaDocElementType.DOC_COMMENT ? null : node;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type2, @NotNull PsiExpression expression2) {
        PsiExpression topLevel;
        if (type2 == null) {
            PsiImplUtil.$$$reportNull$$$0(41);
        }
        if (expression2 == null) {
            PsiImplUtil.$$$reportNull$$$0(42);
        }
        PsiUtil.ensureValidType(type2);
        for (topLevel = expression2; topLevel.getParent() instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)topLevel.getParent()).getArrayExpression() == topLevel; topLevel = (PsiExpression)topLevel.getParent()) {
        }
        if (topLevel instanceof PsiArrayAccessExpression && !PsiUtil.isAccessedForWriting(topLevel)) {
            return PsiUtil.captureToplevelWildcards(type2, expression2);
        }
        PsiType normalized = PsiImplUtil.doNormalizeWildcardByPosition(type2, expression2, topLevel);
        LOG.assertTrue(normalized.isValid(), type2);
        if (normalized instanceof PsiClassType && !PsiUtil.isAccessedForWriting(topLevel)) {
            return PsiUtil.captureToplevelWildcards(normalized, expression2);
        }
        return normalized;
    }

    private static PsiType doNormalizeWildcardByPosition(PsiType type2, @NotNull PsiExpression expression2, @NotNull PsiExpression topLevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (expression2 == null) {
            PsiImplUtil.$$$reportNull$$$0(43);
        }
        if (topLevel == null) {
            PsiImplUtil.$$$reportNull$$$0(44);
        }
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (PsiUtil.isAccessedForWriting(topLevel)) {
                return wildcardType.isSuper() ? wildcardType.getBound() : PsiCapturedWildcardType.create(wildcardType, expression2);
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return PsiType.getJavaLangObject(expression2.getManager(), expression2.getResolveScope());
        }
        if (type2 instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type2).getComponentType(), expression2, topLevel)) != componentType) {
            return normalizedComponentType.createArrayType();
        }
        return type2;
    }

    @NotNull
    public static SearchScope getMemberUseScope(@NotNull PsiMember member) {
        PsiPackage aPackage;
        int accessLevel;
        PsiFile file2;
        if (member == null) {
            PsiImplUtil.$$$reportNull$$$0(45);
        }
        NavigatablePsiElement topElement = (file2 = member.getContainingFile()) == null ? member : file2;
        Project project = topElement.getProject();
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getInstance(project).getUseScope(topElement);
        if (PsiImplUtil.isInServerPage(file2)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(46);
            }
            return globalSearchScope;
        }
        PsiClass aClass = member.getContainingClass();
        if (!(!(aClass instanceof PsiAnonymousClass) || aClass instanceof PsiEnumConstantInitializer && member instanceof PsiMethod && member.hasModifierProperty("public") && ((PsiMethod)member).findSuperMethods().length > 0)) {
            PsiElement[] elements;
            PsiElement scope2;
            PsiElement psiElement = scope2 = PsiUtil.isLanguageLevel8OrHigher(aClass) ? PsiTreeUtil.getTopmostParentOfType(aClass, PsiStatement.class) : PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMethodCallExpression.class);
            if (scope2 instanceof PsiDeclarationStatement && (elements = ((PsiDeclarationStatement)scope2).getDeclaredElements()).length == 1 && elements[0] instanceof PsiLocalVariable && ((PsiLocalVariable)elements[0]).getTypeElement().isInferredType()) {
                scope2 = scope2.getParent();
            }
            return new LocalSearchScope(scope2 != null ? scope2 : aClass);
        }
        PsiModifierList modifierList2 = member.getModifierList();
        int n = accessLevel = modifierList2 == null ? 4 : PsiUtil.getAccessLevel(modifierList2);
        if (accessLevel == 4 || accessLevel == 3) {
            PsiClass containingClass;
            if (member instanceof PsiMethod && ((PsiMethod)member).isConstructor() && (containingClass = member.getContainingClass()) != null) {
                SearchScope searchScope = containingClass.getUseScope();
                if (searchScope == null) {
                    PsiImplUtil.$$$reportNull$$$0(47);
                }
                return searchScope;
            }
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(48);
            }
            return globalSearchScope;
        }
        if (accessLevel == 1) {
            PsiClass topClass = PsiUtil.getTopLevelClass(member);
            return topClass != null ? new LocalSearchScope(topClass) : (file2 == null ? maximalUseScope : new LocalSearchScope(file2));
        }
        if (file2 instanceof PsiJavaFile && (aPackage = JavaPsiFacade.getInstance(project).findPackage(((PsiJavaFile)file2).getPackageName())) != null) {
            GlobalSearchScope scope3 = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope = ((SearchScope)scope3).intersectWith(maximalUseScope);
            if (searchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(49);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = maximalUseScope;
        if (globalSearchScope == null) {
            PsiImplUtil.$$$reportNull$$$0(50);
        }
        return globalSearchScope;
    }

    public static boolean isInServerPage(@Nullable PsiElement element) {
        return PsiImplUtil.getServerPageFile(element) != null;
    }

    @Nullable
    private static ServerPageFile getServerPageFile(PsiElement element) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile(element);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    public static PsiElement setName(@NotNull PsiElement element, @NotNull String name2) throws IncorrectOperationException {
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(51);
        }
        if (name2 == null) {
            PsiImplUtil.$$$reportNull$$$0(52);
        }
        PsiManager manager = element.getManager();
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(manager.getProject());
        PsiIdentifier newNameIdentifier = factory2.createIdentifier(name2);
        return element.replace(newNameIdentifier);
    }

    public static boolean isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(53);
        }
        return AnnotationUtil.findAnnotation(owner, "java.lang.Deprecated") != null;
    }

    public static boolean isDeprecatedByDocTag(@NotNull PsiJavaDocumentedElement owner) {
        PsiDocComment docComment;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(54);
        }
        return (docComment = owner.getDocComment()) != null && docComment.findTagByName("deprecated") != null;
    }

    public static boolean isDeprecated(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PsiImplUtil.$$$reportNull$$$0(55);
        }
        if (psiElement instanceof PsiDocCommentOwner) {
            return ((PsiDocCommentOwner)psiElement).isDeprecated();
        }
        if (psiElement instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)psiElement)) {
            return true;
        }
        if (psiElement instanceof PsiJavaDocumentedElement) {
            return PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)psiElement);
        }
        return false;
    }

    @Nullable
    public static PsiJavaDocumentedElement findDocCommentOwner(@NotNull PsiDocComment comment) {
        PsiJavaDocumentedElement owner;
        PsiElement parent2;
        if (comment == null) {
            PsiImplUtil.$$$reportNull$$$0(56);
        }
        if ((parent2 = comment.getParent()) instanceof PsiJavaDocumentedElement && (owner = (PsiJavaDocumentedElement)parent2).getDocComment() == comment) {
            return owner;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue setDeclaredAttributeValue(@NotNull PsiAnnotation psiAnnotation, @Nullable String attributeName, @Nullable PsiAnnotationMemberValue value2, @NotNull PairFunction<? super Project, ? super String, ? extends PsiAnnotation> annotationCreator) {
        if (psiAnnotation == null) {
            PsiImplUtil.$$$reportNull$$$0(57);
        }
        if (annotationCreator == null) {
            PsiImplUtil.$$$reportNull$$$0(58);
        }
        PsiAnnotationMemberValue existing = psiAnnotation.findDeclaredAttributeValue(attributeName);
        if (value2 == null) {
            if (existing == null) {
                return null;
            }
            existing.getParent().delete();
        } else if (existing != null) {
            ((PsiNameValuePair)existing.getParent()).setValue(value2);
        } else {
            PsiNameValuePair attribute;
            PsiNameValuePair[] attributes = psiAnnotation.getParameterList().getAttributes();
            if (attributes.length == 1 && (attribute = attributes[0]).getName() == null) {
                PsiAnnotationMemberValue defValue = attribute.getValue();
                assert (defValue != null) : attribute;
                attribute.replace(PsiImplUtil.createNameValuePair(defValue, "value=", annotationCreator));
            }
            boolean allowNoName = attributes.length == 0 && ("value".equals(attributeName) || null == attributeName);
            String namePrefix = allowNoName ? "" : attributeName + "=";
            psiAnnotation.getParameterList().addBefore(PsiImplUtil.createNameValuePair(value2, namePrefix, annotationCreator), null);
        }
        return psiAnnotation.findDeclaredAttributeValue(attributeName);
    }

    private static PsiNameValuePair createNameValuePair(@NotNull PsiAnnotationMemberValue value2, @NotNull String namePrefix, @NotNull PairFunction<? super Project, ? super String, ? extends PsiAnnotation> annotationCreator) {
        if (value2 == null) {
            PsiImplUtil.$$$reportNull$$$0(59);
        }
        if (namePrefix == null) {
            PsiImplUtil.$$$reportNull$$$0(60);
        }
        if (annotationCreator == null) {
            PsiImplUtil.$$$reportNull$$$0(61);
        }
        return annotationCreator.fun(value2.getProject(), "@A(" + namePrefix + value2.getText() + ")").getParameterList().getAttributes()[0];
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(ASTNode node) {
        return TreeUtil.skipWhitespaceAndComments(node, true);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(ASTNode node, @NotNull TokenSet alsoSkip) {
        if (alsoSkip == null) {
            PsiImplUtil.$$$reportNull$$$0(62);
        }
        return TreeUtil.skipWhitespaceCommentsAndTokens(node, alsoSkip, true);
    }

    public static boolean isWhitespaceOrComment(ASTNode element) {
        return TreeUtil.isWhitespaceOrComment(element);
    }

    @Nullable
    public static ASTNode skipWhitespaceAndCommentsBack(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (!PsiImplUtil.isWhitespaceOrComment(node)) {
            return node;
        }
        ASTNode parent2 = node.getTreeParent();
        ASTNode prev = node;
        while (prev instanceof CompositeElement) {
            if (!PsiImplUtil.isWhitespaceOrComment(prev)) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent2.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (PsiImplUtil.isWhitespaceOrComment(firstChildNode)) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findStatementChild(@NotNull CompositePsiElement statement) {
        if (statement == null) {
            PsiImplUtil.$$$reportNull$$$0(63);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = statement.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!(element.getPsi() instanceof PsiStatement)) continue;
            return element;
        }
        return null;
    }

    public static PsiStatement @NotNull [] getChildStatements(@NotNull CompositeElement psiCodeBlock) {
        if (psiCodeBlock == null) {
            PsiImplUtil.$$$reportNull$$$0(64);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (ASTNode child1 = psiCodeBlock.getFirstChildNode(); child1 != null; child1 = child1.getTreeNext()) {
            if (!(child1.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        PsiStatement[] result2 = PsiStatement.ARRAY_FACTORY.create(count);
        if (count == 0) {
            if (result2 == null) {
                PsiImplUtil.$$$reportNull$$$0(65);
            }
            return result2;
        }
        int idx = 0;
        for (ASTNode child = psiCodeBlock.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            PsiElement element = child.getPsi();
            if (!(element instanceof PsiStatement)) continue;
            result2[idx++] = (PsiStatement)element;
        }
        if (result2 == null) {
            PsiImplUtil.$$$reportNull$$$0(66);
        }
        return result2;
    }

    public static boolean isVarArgs(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            PsiImplUtil.$$$reportNull$$$0(67);
        }
        return (parameters = method.getParameterList().getParameters()).length > 0 && parameters[parameters.length - 1].isVarArgs();
    }

    public static PsiElement handleMirror(PsiElement element) {
        return element instanceof PsiMirrorElement ? ((PsiMirrorElement)element).getPrototype() : element;
    }

    @Nullable
    public static PsiModifierList findNeighbourModifierList(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement grandParent;
        PsiElement parent2;
        if (ref == null) {
            PsiImplUtil.$$$reportNull$$$0(68);
        }
        if ((parent2 = PsiTreeUtil.skipParentsOfType(ref, PsiJavaCodeReferenceElement.class)) instanceof PsiTypeElement && (grandParent = parent2.getParent()) instanceof PsiModifierListOwner) {
            return ((PsiModifierListOwner)grandParent).getModifierList();
        }
        return null;
    }

    public static boolean isTypeAnnotation(@Nullable PsiElement element) {
        return element instanceof PsiAnnotation && AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)element);
    }

    public static void collectTypeUseAnnotations(@NotNull PsiModifierList modifierList2, @NotNull List<? super PsiAnnotation> annotations2) {
        if (modifierList2 == null) {
            PsiImplUtil.$$$reportNull$$$0(69);
        }
        if (annotations2 == null) {
            PsiImplUtil.$$$reportNull$$$0(70);
        }
        AnnotationTargetUtil.collectStrictlyTypeUseAnnotations(modifierList2, annotations2);
    }

    public static void markTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left;
        if (typeElement == null) {
            PsiImplUtil.$$$reportNull$$$0(71);
        }
        if ((left = PsiTreeUtil.skipSiblingsBackward(typeElement, PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class)) instanceof PsiModifierList) {
            for (PsiAnnotation annotation : ((PsiModifierList)left).getAnnotations()) {
                if (!AnnotationTargetUtil.isTypeAnnotation(annotation)) continue;
                annotation.putUserData(TYPE_ANNO_MARK, Boolean.TRUE);
            }
        }
    }

    public static void deleteTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left;
        if (typeElement == null) {
            PsiImplUtil.$$$reportNull$$$0(72);
        }
        if ((left = PsiTreeUtil.skipSiblingsBackward(typeElement, PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class)) instanceof PsiModifierList) {
            for (PsiAnnotation annotation : ((PsiModifierList)left).getAnnotations()) {
                if (TYPE_ANNO_MARK.get(annotation) != Boolean.TRUE) continue;
                annotation.delete();
            }
        }
    }

    @Nullable
    public static PsiLoopStatement findEnclosingLoop(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(73);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiLoopStatement) {
                return (PsiLoopStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiStatement findEnclosingSwitchOrLoop(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(74);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiSwitchStatement || e instanceof PsiLoopStatement) {
                return (PsiStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiSwitchExpression findEnclosingSwitchExpression(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(75);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiSwitchExpression) {
                return (PsiSwitchExpression)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiLabeledStatement findEnclosingLabeledStatement(@NotNull PsiElement start, @NotNull String label) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(76);
        }
        if (label == null) {
            PsiImplUtil.$$$reportNull$$$0(77);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiLabeledStatement && label.equals(((PsiLabeledStatement)e).getName())) {
                return (PsiLabeledStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @NotNull
    public static List<String> findAllEnclosingLabels(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(78);
        }
        SmartList<String> result2 = new SmartList<String>();
        PsiElement context2 = start;
        while (!PsiImplUtil.isCodeBoundary(context2)) {
            if (context2 instanceof PsiLabeledStatement) {
                result2.add(((PsiLabeledStatement)context2).getName());
            }
            context2 = context2.getContext();
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            PsiImplUtil.$$$reportNull$$$0(79);
        }
        return smartList;
    }

    private static boolean isCodeBoundary(@Nullable PsiElement e) {
        return e == null || e instanceof PsiMethod || e instanceof PsiClassInitializer || e instanceof PsiLambdaExpression;
    }

    @Nullable
    public static PsiSwitchLabelStatementBase getSwitchLabel(@NotNull PsiCaseLabelElement labelElement) {
        PsiElement grand;
        PsiElement parent2;
        if (labelElement == null) {
            PsiImplUtil.$$$reportNull$$$0(80);
        }
        PsiElement psiElement = parent2 = labelElement instanceof PsiParenthesizedPattern ? JavaPsiPatternUtil.skipParenthesizedPatternUp(labelElement.getParent()) : PsiUtil.skipParenthesizedExprUp(labelElement.getParent());
        if (parent2 instanceof PsiCaseLabelElementList && (grand = parent2.getParent()) instanceof PsiSwitchLabelStatementBase) {
            return (PsiSwitchLabelStatementBase)grand;
        }
        return null;
    }

    public static boolean isLeafElementOfType(@Nullable PsiElement element, @NotNull IElementType type2) {
        if (type2 == null) {
            PsiImplUtil.$$$reportNull$$$0(81);
        }
        return element instanceof LeafElement && ((LeafElement)((Object)element)).getElementType() == type2;
    }

    public static boolean isLeafElementOfType(PsiElement element, @NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            PsiImplUtil.$$$reportNull$$$0(82);
        }
        return element instanceof LeafElement && tokenSet.contains(((LeafElement)((Object)element)).getElementType());
    }

    public static PsiType buildTypeFromTypeString(@NotNull String typeName, @NotNull PsiElement context2, @NotNull PsiFile psiFile) {
        PsiClassType resultType;
        PsiClass aClass;
        if (typeName == null) {
            PsiImplUtil.$$$reportNull$$$0(83);
        }
        if (context2 == null) {
            PsiImplUtil.$$$reportNull$$$0(84);
        }
        if (psiFile == null) {
            PsiImplUtil.$$$reportNull$$$0(85);
        }
        PsiManager psiManager = psiFile.getManager();
        if (typeName.indexOf(60) != -1 || typeName.indexOf(91) != -1 || typeName.indexOf(46) == -1) {
            try {
                return JavaPsiFacade.getElementFactory(psiManager.getProject()).createTypeFromText(typeName, context2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((aClass = JavaPsiFacade.getInstance(psiManager.getProject()).findClass(typeName, context2.getResolveScope())) == null) {
            LightClassReference ref = new LightClassReference(psiManager, PsiNameHelper.getShortClassName(typeName), typeName, PsiSubstitutor.EMPTY, psiFile);
            resultType = new PsiClassReferenceType(ref, null);
        } else {
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(psiManager.getProject());
            PsiSubstitutor substitutor2 = factory2.createRawSubstitutor(aClass);
            resultType = factory2.createType(aClass, substitutor2);
        }
        return resultType;
    }

    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult @NotNull [] multiResolveImpl(@NotNull T element, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        FileASTNode fileElement;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(86);
        }
        if (resolver == null) {
            PsiImplUtil.$$$reportNull$$$0(87);
        }
        if ((fileElement = SharedImplUtil.findFileElement(element.getNode())) == null) {
            PsiUtilCore.ensureValid(element);
            LOG.error("fileElement == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(88);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiFile psiFile = SharedImplUtil.getContainingFile(fileElement);
        return PsiImplUtil.multiResolveImpl(element, psiFile, incompleteCode, resolver);
    }

    @NotNull
    public static <T extends PsiJavaCodeReferenceElement> @NotNull JavaResolveResult @NotNull [] multiResolveImpl(@NotNull T element, PsiFile psiFile, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        PsiManager manager;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(89);
        }
        if (resolver == null) {
            PsiImplUtil.$$$reportNull$$$0(90);
        }
        PsiManager psiManager = manager = psiFile == null ? null : psiFile.getManager();
        if (manager == null) {
            PsiUtilCore.ensureValid(element);
            LOG.error("getManager() == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(91);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        boolean valid = psiFile.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid(element);
            LOG.error("psiFile.isValid() == false!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(92);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        if (element instanceof PsiMethodReferenceExpression && ThreadLocalTypes.hasBindingFor(element)) {
            JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])resolver.resolve(element, psiFile, incompleteCode);
            if (javaResolveResultArray == null) {
                PsiImplUtil.$$$reportNull$$$0(93);
            }
            return javaResolveResultArray;
        }
        return PsiImplUtil.multiResolveImpl(manager.getProject(), psiFile, element, incompleteCode, resolver);
    }

    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult @NotNull [] multiResolveImpl(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull T element, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        ResolveResult[] results;
        if (project == null) {
            PsiImplUtil.$$$reportNull$$$0(94);
        }
        if (psiFile == null) {
            PsiImplUtil.$$$reportNull$$$0(95);
        }
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(96);
        }
        if (resolver == null) {
            PsiImplUtil.$$$reportNull$$$0(97);
        }
        JavaResolveResult[] javaResolveResultArray = (results = ResolveCache.getInstance(project).resolveWithCaching(element, resolver, true, incompleteCode, psiFile)).length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            PsiImplUtil.$$$reportNull$$$0(98);
        }
        return javaResolveResultArray;
    }

    @NotNull
    public static VirtualFile getModuleVirtualFile(@NotNull PsiJavaModule module2) {
        if (module2 == null) {
            PsiImplUtil.$$$reportNull$$$0(99);
        }
        if (module2 instanceof LightJavaModule) {
            VirtualFile virtualFile = ((LightJavaModule)module2).getRootVirtualFile();
            if (virtualFile == null) {
                PsiImplUtil.$$$reportNull$$$0(100);
            }
            return virtualFile;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile(module2);
        if (file2 == null) {
            throw new IllegalArgumentException("Module '" + module2 + "' lost its VF; file=" + module2.getContainingFile() + "; valid=" + module2.isValid());
        }
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            PsiImplUtil.$$$reportNull$$$0(101);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiImplUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 4: 
            case 32: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 20: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 25: 
            case 40: 
            case 51: 
            case 86: 
            case 89: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceList";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElements";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAccessExpression";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 41: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevel";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationCreator";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alsoSkip";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiCodeBlock";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelElement";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 85: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 87: 
            case 90: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "namesToPackageReferences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceVariantsByFilter";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "typesByTypeElements";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberUseScope";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildStatements";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllEnclosingLabels";
                break;
            }
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveImpl";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttributeValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameters";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "namesToPackageReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterIndex";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceVariantsByFilter";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInMethod";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInLambda";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInMethodLike";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInResourceList";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeParameters";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "typesByReferenceParameterList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "typesByTypeElements";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWildcardTypeByPosition";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doNormalizeWildcardByPosition";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getMemberUseScope";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByAnnotation";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByDocTag";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findDocCommentOwner";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setDeclaredAttributeValue";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createNameValuePair";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceCommentsAndTokens";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findStatementChild";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getChildStatements";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isVarArgs";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findNeighbourModifierList";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeUseAnnotations";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "markTypeAnnotations";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "deleteTypeAnnotations";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLoop";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingSwitchOrLoop";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingSwitchExpression";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLabeledStatement";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findAllEnclosingLabels";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchLabel";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isLeafElementOfType";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeString";
                break;
            }
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveImpl";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getModuleVirtualFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 16: 
            case 35: 
            case 36: 
            case 38: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 65: 
            case 66: 
            case 79: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 100: 
            case 101: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

