/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.Bits;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.InlineKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.IntToIntBtree;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorWal;
import org.jetbrains.kotlin.com.intellij.util.io.ResizeableMappedFile;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;

public class PersistentBTreeEnumerator<Data>
extends PersistentEnumeratorBase<Data> {
    private static final int BTREE_PAGE_SIZE;
    private static final boolean DO_EXPENSIVE_CHECKS;
    private int myLogicalFileLength;
    private int myDataPageStart;
    private int myFirstPageStart;
    private int myDataPageOffset;
    private int myDuplicatedValuesPageStart;
    private int myDuplicatedValuesPageOffset;
    private int myValuesCount;
    private int myCollisions;
    private int myExistingKeysEnumerated;
    private IntToIntBtree myBTree;
    private final boolean myInlineKeysNoMapping;
    private boolean myExternalKeysNoMapping;
    @Nullable
    private final PersistentEnumeratorWal<Data> myWal;
    protected static final int VERSION;
    private final int[] myResultBuf;

    public PersistentBTreeEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version2, boolean enableWal) throws IOException {
        if (file2 == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(6);
        }
        if (dataDescriptor == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(7);
        }
        super(file2, new ResizeableMappedFile(file2, initialSize, lockContext, 0x100000, true, IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER), dataDescriptor, initialSize, new PersistentEnumeratorBase.Version(VERSION + version2), new RecordBufferHandler(), false);
        this.myResultBuf = new int[1];
        this.myInlineKeysNoMapping = dataDescriptor instanceof InlineKeyDescriptor;
        boolean bl = this.myExternalKeysNoMapping = !(dataDescriptor instanceof InlineKeyDescriptor);
        if (this.myBTree == null) {
            try {
                this.lockStorageWrite();
                this.storeVars(false);
                this.initBtree(false);
                this.storeBTreeVars(false);
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable e) {
                LOG.info(e);
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new PersistentEnumeratorBase.CorruptedException(file2);
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        this.diagnose();
        this.myWal = enableWal ? new PersistentEnumeratorWal<Data>(dataDescriptor, false, file2.resolveSibling(file2.getFileName() + ".wal"), ConcurrencyUtil.newSameThreadExecutorService(), true) : null;
    }

    private void doExpensiveSanityCheck() {
        try {
            LOG.info("Doing self diagnostic for " + this.myFile);
            ArrayList storedData = new ArrayList();
            this.iterateData(data -> {
                storedData.add(data);
                return true;
            });
            for (int i = 0; i < storedData.size(); ++i) {
                try {
                    Object data2 = storedData.get(i);
                    int id = i + 1;
                    if (this.tryEnumerate(data2) != id) {
                        throw new IOException(this.myFile + " is corrupted");
                    }
                    if (this.myDataDescriptor.isEqual(this.valueOf(id), data2)) continue;
                    throw new IOException(this.myFile + " is corrupted");
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    public void diagnose() {
        if (DO_EXPENSIVE_CHECKS && !this.myInlineKeysNoMapping) {
            this.doExpensiveSanityCheck();
        }
    }

    @Override
    protected boolean trySelfHeal() {
        if (!SystemProperties.getBooleanProperty("idea.persistent.enumerator.do.self.heal", false)) {
            return false;
        }
        LOG.info("Trying to self-heal " + this.myFile);
        ArrayList items = new ArrayList();
        try {
            class DataWithOffset {
                final Data data;
                final int offset;

                DataWithOffset(Data data, int offset2) {
                    this.data = data;
                    this.offset = offset2;
                }
            }
            this.doIterateData((offset2, data) -> {
                items.add(new DataWithOffset(data, offset2));
                return true;
            });
            this.lockStorageWrite();
            try {
                this.myStorage.clear();
                this.myKeyStorage.clear();
                this.myStorage.ensureSize(4096L);
                this.markDirty(true);
                this.putMetaData(0L);
                this.putMetaData2(0L);
                if (this.myBTree != null) {
                    this.myBTree.doClose();
                }
                this.setupEmptyFile();
                this.doFlush();
            }
            finally {
                this.unlockStorageWrite();
            }
            for (DataWithOffset item : items) {
                int expectedId = item.offset + 1;
                int id = this.enumerate(item.data);
                if (expectedId == id) continue;
                throw new IOException("Enumeration order has been changed while self-healing, were " + expectedId + " now " + id);
            }
        }
        catch (Throwable throwable) {
            LOG.info(throwable);
            return false;
        }
        return true;
    }

    @NotNull
    private static Path indexFile(@NotNull Path file2) {
        if (file2 == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(8);
        }
        Path path = file2.resolveSibling(file2.getFileName() + "_i");
        if (path == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(9);
        }
        return path;
    }

    private void initBtree(boolean initial) throws IOException {
        this.myBTree = new IntToIntBtree(BTREE_PAGE_SIZE, PersistentBTreeEnumerator.indexFile(this.myFile), this.myStorage.getStorageLockContext(), initial);
    }

    private void storeVars(boolean toDisk) throws IOException {
        this.myLogicalFileLength = this.store(20, this.myLogicalFileLength, toDisk);
        this.myDataPageStart = this.store(24, this.myDataPageStart, toDisk);
        this.myDataPageOffset = this.store(28, this.myDataPageOffset, toDisk);
        this.myFirstPageStart = this.store(32, this.myFirstPageStart, toDisk);
        this.myDuplicatedValuesPageStart = this.store(36, this.myDuplicatedValuesPageStart, toDisk);
        this.myDuplicatedValuesPageOffset = this.store(40, this.myDuplicatedValuesPageOffset, toDisk);
        this.myValuesCount = this.store(44, this.myValuesCount, toDisk);
        this.myCollisions = this.store(48, this.myCollisions, toDisk);
        this.myExistingKeysEnumerated = this.store(52, this.myExistingKeysEnumerated, toDisk);
        this.storeBTreeVars(toDisk);
    }

    private void storeBTreeVars(boolean toDisk) throws IOException {
        IntToIntBtree tree = this.myBTree;
        if (tree != null) {
            int BTREE_DATA_START = 56;
            tree.persistVars(new IntToIntBtree.BtreeDataStorage(){

                @Override
                public int persistInt(int offset2, int value2, boolean toDisk) throws IOException {
                    return PersistentBTreeEnumerator.this.store(56 + offset2, value2, toDisk);
                }
            }, toDisk);
        }
    }

    private int store(int offset2, int value2, boolean toDisk) throws IOException {
        assert (offset2 + 4 < 128);
        if (toDisk) {
            if (this.myFirstPageStart == -1 || this.myStorage.getInt(offset2) != value2) {
                this.myStorage.putInt(offset2, value2);
            }
        } else {
            value2 = this.myStorage.getInt(offset2);
        }
        return value2;
    }

    @Override
    protected void setupEmptyFile() throws IOException {
        this.myLogicalFileLength = 128;
        this.myDataPageStart = -1;
        this.myFirstPageStart = -1;
        this.myDuplicatedValuesPageStart = -1;
        this.initBtree(true);
        this.storeVars(true);
    }

    @Override
    protected void doClose() throws IOException {
        try {
            super.doClose();
        }
        finally {
            IntToIntBtree tree = this.myBTree;
            if (tree != null) {
                tree.doClose();
            }
        }
    }

    private int allocPage() {
        int pageStart = this.myLogicalFileLength;
        this.myLogicalFileLength += 4096 - pageStart % 4096;
        return pageStart;
    }

    @Override
    public boolean processAllDataObject(final @NotNull Processor<? super Data> processor, final @Nullable PersistentEnumeratorBase.DataFilter filter) throws IOException {
        if (processor == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(10);
        }
        if (this.myInlineKeysNoMapping) {
            return this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                @Override
                public boolean process(int record) throws IOException {
                    if (filter == null || filter.accept(record)) {
                        Object data = ((InlineKeyDescriptor)PersistentBTreeEnumerator.this.myDataDescriptor).fromInt(this.getCurrentKey());
                        return processor.process(data);
                    }
                    return true;
                }
            });
        }
        return super.processAllDataObject(processor, filter);
    }

    @Override
    public boolean traverseAllRecords(final @NotNull PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        if (p == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(11);
        }
        this.getReadLock().lock();
        try {
            boolean bl;
            this.lockStorageRead();
            try {
                bl = this.myBTree.processMappings(new IntToIntBtree.KeyValueProcessor(){

                    @Override
                    public boolean process(int key, int value2) throws IOException {
                        p.setCurrentKey(key);
                        if (value2 > 0 || PersistentBTreeEnumerator.this.myInlineKeysNoMapping) {
                            return p.process(value2);
                        }
                        int rec = -value2;
                        while (rec != 0) {
                            int id = PersistentBTreeEnumerator.this.myStorage.getInt(rec);
                            if (!p.process(id)) {
                                return false;
                            }
                            rec = PersistentBTreeEnumerator.this.myStorage.getInt(rec + 4);
                        }
                        return true;
                    }
                });
            }
            catch (Throwable throwable) {
                this.unlockStorageRead();
                throw throwable;
            }
            this.unlockStorageRead();
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    protected int addrToIndex(int addr) {
        assert (this.myExternalKeysNoMapping);
        return addr + 1;
    }

    @Override
    protected int indexToAddr(int idx) throws IOException {
        if (this.myExternalKeysNoMapping) {
            IntToIntBtree.myAssert(idx > 0);
            return idx - 1;
        }
        int anInt = this.myStorage.getInt(idx);
        return anInt;
    }

    @Override
    protected int setupValueId(int hashCode, int dataOff) throws IOException {
        if (this.myExternalKeysNoMapping) {
            return this.addrToIndex(dataOff);
        }
        @NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler = this.getRecordHandler();
        byte[] buf = recordHandler.getRecordBuffer(this);
        int pos = recordHandler.recordWriteOffset(this, buf);
        this.myStorage.ensureSize(pos + buf.length);
        if (!this.myInlineKeysNoMapping) {
            this.myStorage.putInt(pos, dataOff);
        }
        return pos;
    }

    @Override
    public void setRecordHandler(@NotNull PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler) {
        if (recordHandler == null) {
            PersistentBTreeEnumerator.$$$reportNull$$$0(12);
        }
        this.myExternalKeysNoMapping = false;
        super.setRecordHandler(recordHandler);
    }

    @Override
    public Data getValue(int keyId, int processingKey) throws IOException {
        if (this.myInlineKeysNoMapping) {
            return (Data)((InlineKeyDescriptor)this.myDataDescriptor).fromInt(processingKey);
        }
        return super.getValue(keyId, processingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNonNegativeValue(Data key) throws IOException {
        this.getReadLock().lock();
        try {
            block9: {
                long l;
                assert (this.myInlineKeysNoMapping);
                try {
                    this.lockStorageRead();
                    boolean hasMapping = this.myBTree.get(((InlineKeyDescriptor)this.myDataDescriptor).toInt(key), this.myResultBuf);
                    if (hasMapping) break block9;
                    l = 0L;
                }
                catch (Throwable throwable) {
                    this.unlockStorageRead();
                    throw throwable;
                }
                this.unlockStorageRead();
                return l;
            }
            long l = this.keyIdToNonNegativeOffset(this.myResultBuf[0]);
            this.unlockStorageRead();
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    long keyIdToNonNegativeOffset(int value2) throws IOException {
        if (value2 >= 0) {
            return value2;
        }
        return this.myStorage.getLong(-value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putNonNegativeValue(Data key, long value2) throws IOException {
        this.getWriteLock().lock();
        try {
            assert (value2 >= 0L);
            assert (this.myInlineKeysNoMapping);
            try {
                this.lockStorageWrite();
                int intKey = ((InlineKeyDescriptor)this.myDataDescriptor).toInt(key);
                this.markDirty(true);
                if (value2 < Integer.MAX_VALUE) {
                    this.myBTree.put(intKey, (int)value2);
                } else {
                    boolean hasMapping = this.myBTree.get(intKey, this.myResultBuf);
                    if (hasMapping && this.myResultBuf[0] < 0) {
                        this.myStorage.putLong(-this.myResultBuf[0], value2);
                        return;
                    }
                    int pos = this.nextLongValueRecord();
                    this.myStorage.putLong(pos, value2);
                    this.myBTree.put(intKey, -pos);
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private int nextLongValueRecord() {
        assert (this.myInlineKeysNoMapping);
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == 4096) {
            int existingOffset;
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = existingOffset = this.myDuplicatedValuesPageStart % 4096;
            this.myDuplicatedValuesPageStart -= existingOffset;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected int enumerateImpl(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void force() {
        try {
            super.force();
        }
        finally {
            if (this.myWal != null) {
                this.myWal.flush();
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.myWal != null) {
                this.myWal.close();
            }
        }
    }

    @Override
    boolean canReEnumerate() {
        return true;
    }

    @Override
    public Data valueOf(int idx) throws IOException {
        assert (!this.myInlineKeysNoMapping) : "No valueOf for inline keys with no mapping option";
        return super.valueOf(idx);
    }

    private int nextDuplicatedValueRecord() {
        assert (!this.myInlineKeysNoMapping);
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == 4096) {
            int existingOffset;
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = existingOffset = this.myDuplicatedValuesPageStart % 4096;
            this.myDuplicatedValuesPageStart -= existingOffset;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    @Override
    protected void doFlush() throws IOException {
        this.myBTree.doFlush();
        this.storeVars(true);
        super.doFlush();
    }

    static {
        DO_EXPENSIVE_CHECKS = SystemProperties.getBooleanProperty("idea.persistent.enumerator.do.expensive.checks", false);
        BTREE_PAGE_SIZE = SystemProperties.getIntProperty("idea.btree.page.size", 32768);
        assert (0x100000 % BTREE_PAGE_SIZE == 0) : "Page size should be divisor of 1048576";
        VERSION = 8 + IntToIntBtree.version() + BTREE_PAGE_SIZE + 4096 + 128;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentBTreeEnumerator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentBTreeEnumerator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexFile";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllDataObject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "traverseAllRecords";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRecordHandler";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RecordBufferHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentBTreeEnumerator<?>> {
        private ThreadLocal<byte[]> myBuffer;

        private RecordBufferHandler() {
        }

        @Override
        int recordWriteOffset(@NotNull PersistentBTreeEnumerator<?> enumerator, byte @NotNull [] buf) throws IOException {
            if (enumerator == null) {
                RecordBufferHandler.$$$reportNull$$$0(0);
            }
            if (buf == null) {
                RecordBufferHandler.$$$reportNull$$$0(1);
            }
            if (((PersistentBTreeEnumerator)enumerator).myFirstPageStart == -1) {
                ((PersistentBTreeEnumerator)enumerator).myFirstPageStart = (((PersistentBTreeEnumerator)enumerator).myDataPageStart = ((PersistentBTreeEnumerator)enumerator).allocPage());
                int existingOffset = ((PersistentBTreeEnumerator)enumerator).myDataPageStart % 4096;
                ((PersistentBTreeEnumerator)enumerator).myDataPageOffset = existingOffset;
                ((PersistentBTreeEnumerator)enumerator).myDataPageStart -= existingOffset;
            }
            if (((PersistentBTreeEnumerator)enumerator).myDataPageOffset + buf.length + 4 > 4096) {
                assert (((PersistentBTreeEnumerator)enumerator).myDataPageOffset + 4 <= 4096);
                int prevDataPageStart = ((PersistentBTreeEnumerator)enumerator).myDataPageStart + 4096 - 4;
                ((PersistentBTreeEnumerator)enumerator).myDataPageStart = ((PersistentBTreeEnumerator)enumerator).allocPage();
                enumerator.myStorage.putInt(prevDataPageStart, ((PersistentBTreeEnumerator)enumerator).myDataPageStart);
                ((PersistentBTreeEnumerator)enumerator).myDataPageOffset = 0;
            }
            int recordWriteOffset = ((PersistentBTreeEnumerator)enumerator).myDataPageOffset;
            assert (recordWriteOffset + buf.length + 4 <= 4096);
            ((PersistentBTreeEnumerator)enumerator).myDataPageOffset += buf.length;
            return recordWriteOffset + ((PersistentBTreeEnumerator)enumerator).myDataPageStart;
        }

        @Override
        byte @NotNull [] getRecordBuffer(@NotNull PersistentBTreeEnumerator<?> enumerator) {
            if (enumerator == null) {
                RecordBufferHandler.$$$reportNull$$$0(2);
            }
            if (this.myBuffer == null) {
                this.myBuffer = ThreadLocal.withInitial(() -> ((PersistentBTreeEnumerator)enumerator).myInlineKeysNoMapping ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[4]);
            }
            byte[] byArray = this.myBuffer.get();
            if (byArray == null) {
                RecordBufferHandler.$$$reportNull$$$0(3);
            }
            return byArray;
        }

        @Override
        void setupRecord(@NotNull PersistentBTreeEnumerator<?> enumerator, int hashCode, int dataOffset, byte[] buf) {
            if (enumerator == null) {
                RecordBufferHandler.$$$reportNull$$$0(4);
            }
            if (!((PersistentBTreeEnumerator)enumerator).myInlineKeysNoMapping) {
                Bits.putInt(buf, 0, dataOffset);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumerator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buf";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecordBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "recordWriteOffset";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecordBuffer";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setupRecord";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

