/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsAstUtils {
    private static final JsNameRef DEFINE_PROPERTY = JsAstUtils.pureFqn("defineProperty", null);
    private static final JsNameRef VALUE = new JsNameRef("value");
    private static final JsPropertyInitializer WRITABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("writable", null), new JsBooleanLiteral(true));
    private static final JsPropertyInitializer ENUMERABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("enumerable", null), new JsBooleanLiteral(false));

    private JsAstUtils() {
    }

    @NotNull
    public static JsStatement convertToStatement(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$0(0);
        }
        assert (jsNode instanceof JsExpression || jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (jsNode instanceof JsExpression) {
            JsExpression expression2 = (JsExpression)jsNode;
            JsExpressionStatement statement = new JsExpressionStatement(expression2);
            if (expression2 instanceof JsNullLiteral || MetadataProperties.getSynthetic(expression2)) {
                MetadataProperties.setSynthetic(statement, true);
            }
            JsExpressionStatement jsExpressionStatement = statement;
            if (jsExpressionStatement == null) {
                JsAstUtils.$$$reportNull$$$0(1);
            }
            return jsExpressionStatement;
        }
        JsStatement jsStatement = (JsStatement)jsNode;
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(2);
        }
        return jsStatement;
    }

    @NotNull
    public static JsBlock convertToBlock(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$0(3);
        }
        if (jsNode instanceof JsBlock) {
            JsBlock jsBlock = (JsBlock)jsNode;
            if (jsBlock == null) {
                JsAstUtils.$$$reportNull$$$0(4);
            }
            return jsBlock;
        }
        JsBlock block = new JsBlock();
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$0(5);
        }
        return jsBlock;
    }

    @NotNull
    private static JsStatement deBlockIfPossible(@NotNull JsStatement statement) {
        if (statement == null) {
            JsAstUtils.$$$reportNull$$$0(6);
        }
        if (statement instanceof JsBlock && ((JsBlock)statement).getStatements().size() == 1) {
            JsStatement jsStatement = ((JsBlock)statement).getStatements().get(0);
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(7);
            }
            return jsStatement;
        }
        JsStatement jsStatement = statement;
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(8);
        }
        return jsStatement;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$0(9);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$0(10);
        }
        elseStatement = elseStatement != null ? JsAstUtils.deBlockIfPossible(elseStatement) : null;
        return new JsIf(ifExpression, JsAstUtils.deBlockIfPossible(thenStatement), elseStatement);
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement) {
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$0(11);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$0(12);
        }
        return JsAstUtils.newJsIf(ifExpression, thenStatement, null);
    }

    @Nullable
    public static JsExpression extractExpressionFromStatement(@Nullable JsStatement statement) {
        return statement instanceof JsExpressionStatement ? ((JsExpressionStatement)statement).getExpression() : null;
    }

    @NotNull
    public static JsStatement mergeStatementInBlockIfNeeded(@NotNull JsStatement statement, @NotNull JsBlock block) {
        if (statement == null) {
            JsAstUtils.$$$reportNull$$$0(13);
        }
        if (block == null) {
            JsAstUtils.$$$reportNull$$$0(14);
        }
        if (block.isEmpty()) {
            JsStatement jsStatement = statement;
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(15);
            }
            return jsStatement;
        }
        if (JsAstUtils.isEmptyStatement(statement)) {
            return JsAstUtils.deBlockIfPossible(block);
        }
        block.getStatements().add(statement);
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$0(16);
        }
        return jsBlock;
    }

    public static boolean isEmptyStatement(@NotNull JsStatement statement) {
        if (statement == null) {
            JsAstUtils.$$$reportNull$$$0(17);
        }
        return statement instanceof JsEmpty;
    }

    @NotNull
    public static JsInvocation invokeKotlinFunction(@NotNull String name2, JsExpression ... argument) {
        if (name2 == null) {
            JsAstUtils.$$$reportNull$$$0(18);
        }
        if (argument == null) {
            JsAstUtils.$$$reportNull$$$0(19);
        }
        return JsAstUtils.invokeMethod(Namer.kotlinObject(), name2, argument);
    }

    @NotNull
    public static JsInvocation invokeMethod(@NotNull JsExpression thisObject, @NotNull String name2, JsExpression ... arguments) {
        if (thisObject == null) {
            JsAstUtils.$$$reportNull$$$0(20);
        }
        if (name2 == null) {
            JsAstUtils.$$$reportNull$$$0(21);
        }
        if (arguments == null) {
            JsAstUtils.$$$reportNull$$$0(22);
        }
        return new JsInvocation((JsExpression)JsAstUtils.pureFqn(name2, thisObject), arguments);
    }

    @NotNull
    public static JsExpression toInt32(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(23);
        }
        return new JsBinaryOperation(JsBinaryOperator.BIT_OR, expression2, new JsIntLiteral(0));
    }

    @Nullable
    public static JsExpression extractToInt32Argument(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(24);
        }
        if (!(expression2 instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expression2;
        if (binary.getOperator() != JsBinaryOperator.BIT_OR) {
            return null;
        }
        if (!(binary.getArg2() instanceof JsIntLiteral)) {
            return null;
        }
        JsIntLiteral arg2 = (JsIntLiteral)binary.getArg2();
        return arg2.value == 0 ? binary.getArg1() : null;
    }

    @NotNull
    public static JsExpression charToInt(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(25);
        }
        return JsAstUtils.toInt32(expression2);
    }

    @NotNull
    public static JsExpression charToString(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(26);
        }
        return new JsInvocation((JsExpression)new JsNameRef("fromCharCode", (JsExpression)new JsNameRef("String")), expression2);
    }

    @NotNull
    public static JsExpression compareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(27);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(28);
        }
        return JsAstUtils.invokeKotlinFunction(OperatorNameConventions.COMPARE_TO.getIdentifier(), left, right);
    }

    @NotNull
    public static JsExpression primitiveCompareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(29);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(30);
        }
        return JsAstUtils.invokeKotlinFunction("primitiveCompareTo", left, right);
    }

    public static JsExpression newLong(long value2) {
        JsExpression result2;
        if (value2 < Integer.MIN_VALUE || value2 > Integer.MAX_VALUE) {
            if (value2 == Long.MAX_VALUE) {
                return new JsNameRef("MAX_VALUE", (JsExpression)Namer.kotlinLong());
            }
            if (value2 == Long.MIN_VALUE) {
                return new JsNameRef("MIN_VALUE", (JsExpression)Namer.kotlinLong());
            }
            int low = (int)value2;
            int high = (int)(value2 >> 32);
            SmartList<JsIntLiteral> args = new SmartList<JsIntLiteral>();
            args.add(new JsIntLiteral(low));
            args.add(new JsIntLiteral(high));
            result2 = new JsNew((JsExpression)Namer.kotlinLong(), args);
        } else {
            result2 = value2 == 0L ? new JsNameRef("ZERO", (JsExpression)Namer.kotlinLong()) : (value2 == 1L ? new JsNameRef("ONE", (JsExpression)Namer.kotlinLong()) : (value2 == -1L ? new JsNameRef("NEG_ONE", (JsExpression)Namer.kotlinLong()) : JsAstUtils.longFromInt(new JsIntLiteral((int)value2))));
        }
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        return result2;
    }

    @NotNull
    public static JsExpression longFromInt(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(31);
        }
        return JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromInt", expression2);
    }

    @NotNull
    public static JsExpression longFromNumber(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(32);
        }
        return JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromNumber", expression2);
    }

    @NotNull
    public static JsExpression longToNumber(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(33);
        }
        return JsAstUtils.invokeMethod(expression2, "toNumber", new JsExpression[0]);
    }

    @NotNull
    public static JsExpression byteToUByte(byte value2, @NotNull TranslationContext context2) {
        if (context2 == null) {
            JsAstUtils.$$$reportNull$$$0(34);
        }
        JsExpression jsExpression = JsAstUtils.toUnsignedNumber(new JsIntLiteral(value2), context2, StandardNames.FqNames.uByte);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(35);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression shortToUShort(short value2, @NotNull TranslationContext context2) {
        if (context2 == null) {
            JsAstUtils.$$$reportNull$$$0(36);
        }
        JsExpression jsExpression = JsAstUtils.toUnsignedNumber(new JsIntLiteral(value2), context2, StandardNames.FqNames.uShort);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(37);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression intToUInt(int value2, @NotNull TranslationContext context2) {
        if (context2 == null) {
            JsAstUtils.$$$reportNull$$$0(38);
        }
        JsExpression jsExpression = JsAstUtils.toUnsignedNumber(new JsIntLiteral(value2), context2, StandardNames.FqNames.uInt);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(39);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression longToULong(@NotNull JsExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(40);
        }
        if (context2 == null) {
            JsAstUtils.$$$reportNull$$$0(41);
        }
        JsExpression jsExpression = JsAstUtils.toUnsignedNumber(expression2, context2, StandardNames.FqNames.uLong);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(42);
        }
        return jsExpression;
    }

    private static JsExpression toUnsignedNumber(@NotNull JsExpression expression2, @NotNull TranslationContext context2, @NotNull ClassId unsignedClassId) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(43);
        }
        if (context2 == null) {
            JsAstUtils.$$$reportNull$$$0(44);
        }
        if (unsignedClassId == null) {
            JsAstUtils.$$$reportNull$$$0(45);
        }
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(context2.getCurrentModule(), unsignedClassId);
        assert (classDescriptor != null) : "Class descriptor is null for " + unsignedClassId;
        return new JsNew(ReferenceTranslator.translateAsTypeReference(classDescriptor, context2), Collections.singletonList(expression2));
    }

    @NotNull
    public static JsExpression compareForObject(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(46);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(47);
        }
        return JsAstUtils.invokeMethod(left, "compareTo_11rb$", right);
    }

    @NotNull
    public static JsExpression notOptimized(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(48);
        }
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation unary = (JsUnaryOperation)expression2;
            if (unary.getOperator() == JsUnaryOperator.NOT) {
                JsExpression jsExpression = unary.getArg();
                if (jsExpression == null) {
                    JsAstUtils.$$$reportNull$$$0(49);
                }
                return jsExpression;
            }
        } else if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)expression2;
            switch (binary.getOperator()) {
                case AND: {
                    return JsAstUtils.or(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                }
                case OR: {
                    return JsAstUtils.and(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                }
                case EQ: {
                    return new JsBinaryOperation(JsBinaryOperator.NEQ, binary.getArg1(), binary.getArg2());
                }
                case NEQ: {
                    return new JsBinaryOperation(JsBinaryOperator.EQ, binary.getArg1(), binary.getArg2());
                }
                case REF_EQ: {
                    return JsAstUtils.inequality(binary.getArg1(), binary.getArg2());
                }
                case REF_NEQ: {
                    return JsAstUtils.equality(binary.getArg1(), binary.getArg2());
                }
                case LT: {
                    return JsAstUtils.greaterThanEq(binary.getArg1(), binary.getArg2());
                }
                case LTE: {
                    return JsAstUtils.greaterThan(binary.getArg1(), binary.getArg2());
                }
                case GT: {
                    return JsAstUtils.lessThanEq(binary.getArg1(), binary.getArg2());
                }
                case GTE: {
                    return JsAstUtils.lessThan(binary.getArg1(), binary.getArg2());
                }
            }
        }
        return JsAstUtils.not(expression2);
    }

    @NotNull
    public static JsBinaryOperation and(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(50);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(51);
        }
        return new JsBinaryOperation(JsBinaryOperator.AND, op1, op2);
    }

    @NotNull
    public static JsBinaryOperation or(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(52);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(53);
        }
        return new JsBinaryOperation(JsBinaryOperator.OR, op1, op2);
    }

    @NotNull
    public static JsBinaryOperation equality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(56);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(57);
        }
        return new JsBinaryOperation(JsBinaryOperator.REF_EQ, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation inequality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(58);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(59);
        }
        return new JsBinaryOperation(JsBinaryOperator.REF_NEQ, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation lessThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(60);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(61);
        }
        return new JsBinaryOperation(JsBinaryOperator.LTE, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation lessThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(62);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(63);
        }
        return new JsBinaryOperation(JsBinaryOperator.LT, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation greaterThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(64);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(65);
        }
        return new JsBinaryOperation(JsBinaryOperator.GT, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation greaterThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(66);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(67);
        }
        return new JsBinaryOperation(JsBinaryOperator.GTE, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation assignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(68);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(69);
        }
        return new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
    }

    @NotNull
    public static JsStatement assignmentToThisField(@NotNull String fieldName, @NotNull JsExpression right) {
        if (fieldName == null) {
            JsAstUtils.$$$reportNull$$$0(70);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(71);
        }
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), right).source(right.getSource()).makeStmt();
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(72);
        }
        return jsStatement;
    }

    public static JsStatement asSyntheticStatement(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(73);
        }
        JsExpressionStatement statement = new JsExpressionStatement(expression2);
        MetadataProperties.setSynthetic(statement, true);
        return statement;
    }

    @Nullable
    public static Pair<JsExpression, JsExpression> decomposeAssignment(@NotNull JsExpression expr) {
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(74);
        }
        if (!(expr instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expr;
        if (binary.getOperator() != JsBinaryOperator.ASG) {
            return null;
        }
        return new Pair((Object)binary.getArg1(), (Object)binary.getArg2());
    }

    @Nullable
    public static Pair<JsName, JsExpression> decomposeAssignmentToVariable(@NotNull JsExpression expr) {
        Pair<JsExpression, JsExpression> assignment;
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(75);
        }
        if ((assignment = JsAstUtils.decomposeAssignment(expr)) == null || !(assignment.getFirst() instanceof JsNameRef)) {
            return null;
        }
        JsNameRef nameRef = (JsNameRef)assignment.getFirst();
        if (nameRef.getName() == null || nameRef.getQualifier() != null) {
            return null;
        }
        return new Pair((Object)nameRef.getName(), assignment.getSecond());
    }

    @NotNull
    public static JsBinaryOperation sum(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(76);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(77);
        }
        return new JsBinaryOperation(JsBinaryOperator.ADD, left, right);
    }

    @NotNull
    public static JsBinaryOperation addAssign(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(78);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(79);
        }
        return new JsBinaryOperation(JsBinaryOperator.ASG_ADD, left, right);
    }

    @NotNull
    public static JsBinaryOperation subtract(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(80);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(81);
        }
        return new JsBinaryOperation(JsBinaryOperator.SUB, left, right);
    }

    @NotNull
    public static JsBinaryOperation mul(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(82);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(83);
        }
        return new JsBinaryOperation(JsBinaryOperator.MUL, left, right);
    }

    @NotNull
    public static JsBinaryOperation div(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(84);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(85);
        }
        return new JsBinaryOperation(JsBinaryOperator.DIV, left, right);
    }

    @NotNull
    public static JsBinaryOperation mod(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(86);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(87);
        }
        return new JsBinaryOperation(JsBinaryOperator.MOD, left, right);
    }

    @NotNull
    public static JsPrefixOperation not(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(88);
        }
        return new JsPrefixOperation(JsUnaryOperator.NOT, expression2);
    }

    @NotNull
    public static JsBinaryOperation typeOfIs(@NotNull JsExpression expression2, @NotNull JsStringLiteral string2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(89);
        }
        if (string2 == null) {
            JsAstUtils.$$$reportNull$$$0(90);
        }
        return JsAstUtils.equality(new JsPrefixOperation(JsUnaryOperator.TYPEOF, expression2), string2);
    }

    @NotNull
    public static JsVars newVar(@NotNull JsName name2, @Nullable JsExpression expr) {
        if (name2 == null) {
            JsAstUtils.$$$reportNull$$$0(91);
        }
        return new JsVars(new JsVars.JsVar(name2, expr));
    }

    @NotNull
    public static JsExpression newSequence(@NotNull List<JsExpression> expressions) {
        if (expressions == null) {
            JsAstUtils.$$$reportNull$$$0(92);
        }
        assert (!expressions.isEmpty());
        if (expressions.size() == 1) {
            JsExpression jsExpression = expressions.get(0);
            if (jsExpression == null) {
                JsAstUtils.$$$reportNull$$$0(93);
            }
            return jsExpression;
        }
        JsExpression result2 = expressions.get(0);
        for (int i = 1; i < expressions.size(); ++i) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, result2, expressions.get(i));
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(94);
        }
        return jsExpression;
    }

    @NotNull
    public static JsFunction createFunctionWithEmptyBody(@NotNull JsScope parent2) {
        if (parent2 == null) {
            JsAstUtils.$$$reportNull$$$0(95);
        }
        return new JsFunction(parent2, new JsBlock(), "<anonymous>");
    }

    @NotNull
    public static List<JsExpression> toStringLiteralList(@NotNull List<String> strings2) {
        if (strings2 == null) {
            JsAstUtils.$$$reportNull$$$0(96);
        }
        if (strings2.isEmpty()) {
            List<JsExpression> list = Collections.emptyList();
            if (list == null) {
                JsAstUtils.$$$reportNull$$$0(97);
            }
            return list;
        }
        SmartList<JsExpression> result2 = new SmartList<JsExpression>();
        for (String str : strings2) {
            result2.add(new JsStringLiteral(str));
        }
        SmartList<JsExpression> smartList = result2;
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$0(98);
        }
        return smartList;
    }

    @NotNull
    public static JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name2, @NotNull JsExpression value2) {
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(99);
        }
        if (name2 == null) {
            JsAstUtils.$$$reportNull$$$0(100);
        }
        if (value2 == null) {
            JsAstUtils.$$$reportNull$$$0(101);
        }
        return new JsInvocation((JsExpression)DEFINE_PROPERTY.deepCopy(), receiver, new JsStringLiteral(name2), value2);
    }

    @NotNull
    public static JsStatement defineSimpleProperty(@NotNull JsName name2, @NotNull JsExpression value2, @Nullable SourceElement source) {
        if (name2 == null) {
            JsAstUtils.$$$reportNull$$$0(102);
        }
        if (value2 == null) {
            JsAstUtils.$$$reportNull$$$0(103);
        }
        JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(name2, (JsExpression)new JsThisRef()), value2);
        if (source != null) {
            assignment.setSource(PsiSourceElementKt.getPsi(source));
        }
        JsStatement jsStatement = assignment.makeStmt();
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(104);
        }
        return jsStatement;
    }

    @NotNull
    public static JsObjectLiteral createDataDescriptor(@NotNull JsExpression value2, boolean writable, boolean enumerable) {
        if (value2 == null) {
            JsAstUtils.$$$reportNull$$$0(105);
        }
        JsObjectLiteral dataDescriptor = new JsObjectLiteral();
        dataDescriptor.getPropertyInitializers().add(new JsPropertyInitializer(VALUE.deepCopy(), value2));
        if (writable) {
            dataDescriptor.getPropertyInitializers().add(WRITABLE.deepCopy());
        }
        if (enumerable) {
            dataDescriptor.getPropertyInitializers().add(ENUMERABLE.deepCopy());
        }
        JsObjectLiteral jsObjectLiteral = dataDescriptor;
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$0(106);
        }
        return jsObjectLiteral;
    }

    @NotNull
    public static JsObjectLiteral wrapValue(@NotNull JsExpression label, @NotNull JsExpression value2) {
        if (label == null) {
            JsAstUtils.$$$reportNull$$$0(107);
        }
        if (value2 == null) {
            JsAstUtils.$$$reportNull$$$0(108);
        }
        return new JsObjectLiteral(Collections.singletonList(new JsPropertyInitializer(label, value2)));
    }

    @NotNull
    public static List<JsStatement> flattenStatement(@NotNull JsStatement statement) {
        if (statement == null) {
            JsAstUtils.$$$reportNull$$$0(109);
        }
        if (statement instanceof JsBlock) {
            List<JsStatement> list = ((JsBlock)statement).getStatements();
            if (list == null) {
                JsAstUtils.$$$reportNull$$$0(110);
            }
            return list;
        }
        return new SmartList<JsStatement>(statement);
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull String identifier, @Nullable JsExpression qualifier) {
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$0(111);
        }
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(112);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull JsName identifier, @Nullable JsExpression qualifier) {
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$0(113);
        }
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(114);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsInvocation invokeBind(@NotNull JsExpression receiver, @NotNull JsExpression method) {
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(115);
        }
        if (method == null) {
            JsAstUtils.$$$reportNull$$$0(116);
        }
        return JsAstUtils.invokeMethod(method, "bind", receiver);
    }

    public static boolean isUndefinedExpression(JsExpression expression2) {
        if (!(expression2 instanceof JsUnaryOperation)) {
            return false;
        }
        JsUnaryOperation unary = (JsUnaryOperation)expression2;
        return unary.getOperator() == JsUnaryOperator.VOID;
    }

    @NotNull
    public static JsExpression defineGetter(@NotNull JsExpression receiver, @NotNull String name2, @NotNull JsExpression body2) {
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(117);
        }
        if (name2 == null) {
            JsAstUtils.$$$reportNull$$$0(118);
        }
        if (body2 == null) {
            JsAstUtils.$$$reportNull$$$0(119);
        }
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        propertyLiteral.getPropertyInitializers().add(new JsPropertyInitializer(new JsNameRef("get"), body2));
        return JsAstUtils.defineProperty(receiver, name2, propertyLiteral);
    }

    @NotNull
    public static JsExpression prototypeOf(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(120);
        }
        return JsAstUtils.pureFqn("prototype", expression2);
    }

    @NotNull
    public static JsExpression stateMachineReceiver() {
        JsNameRef result2 = JsAstUtils.pureFqn("$this$", null);
        MetadataProperties.setCoroutineReceiver(result2, true);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(121);
        }
        return jsNameRef;
    }

    static {
        JsNameRef globalObjectReference = new JsNameRef("Object");
        DEFINE_PROPERTY.setQualifier(globalObjectReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 49: 
            case 72: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 104: 
            case 106: 
            case 110: 
            case 112: 
            case 114: 
            case 121: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 49: 
            case 72: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 104: 
            case 106: 
            case 110: 
            case 112: 
            case 114: 
            case 121: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsNode";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 49: 
            case 72: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 104: 
            case 106: 
            case 110: 
            case 112: 
            case 114: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 6: 
            case 13: 
            case 17: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifExpression";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenStatement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 18: 
            case 21: 
            case 91: 
            case 100: 
            case 102: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObject";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 43: 
            case 48: 
            case 73: 
            case 88: 
            case 89: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: 
            case 29: 
            case 46: 
            case 68: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 28: 
            case 30: 
            case 47: 
            case 69: 
            case 71: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsignedClassId";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op1";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op2";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg1";
                break;
            }
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg2";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 99: 
            case 115: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 101: 
            case 103: 
            case 105: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBlock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deBlockIfPossible";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "byteToUByte";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "shortToUShort";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "intToUInt";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "longToULong";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "notOptimized";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentToThisField";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "newSequence";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralList";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "defineSimpleProperty";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataDescriptor";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenStatement";
                break;
            }
            case 112: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "pureFqn";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "stateMachineReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToStatement";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 49: 
            case 72: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 104: 
            case 106: 
            case 110: 
            case 112: 
            case 114: 
            case 121: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deBlockIfPossible";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newJsIf";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyStatement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invokeKotlinFunction";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toInt32";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "extractToInt32Argument";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "charToInt";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "charToString";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "primitiveCompareTo";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "longFromInt";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "longFromNumber";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "longToNumber";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "byteToUByte";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shortToUShort";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "intToUInt";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "longToULong";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "toUnsignedNumber";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "compareForObject";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "notOptimized";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setQualifierForNameRef";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "equality";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "inequality";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lessThanEq";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lessThan";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "greaterThan";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "greaterThanEq";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "assignment";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "assignmentToThisField";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "asSyntheticStatement";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignment";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignmentToVariable";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "sum";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addAssign";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "mul";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "mod";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "typeOfIs";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "newVar";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "newSequence";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionWithEmptyBody";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralList";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "defineProperty";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "defineSimpleProperty";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "createDataDescriptor";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "wrapValue";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "flattenStatement";
                break;
            }
            case 111: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "pureFqn";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "invokeBind";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "defineGetter";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "prototypeOf";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 49: 
            case 72: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 104: 
            case 106: 
            case 110: 
            case 112: 
            case 114: 
            case 121: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

