/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsDataFlowExtras;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsOnExtensionReceiverCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkReceiver", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "frontend.java"})
public final class RuntimeAssertionsOnExtensionReceiverCallChecker
implements CallChecker {
    @NotNull
    public static final RuntimeAssertionsOnExtensionReceiverCallChecker INSTANCE = new RuntimeAssertionsOnExtensionReceiverCallChecker();

    private RuntimeAssertionsOnExtensionReceiverCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        if (CallUtilKt.isSafeCall(call2)) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        Object callee = obj;
        this.checkReceiver(callee.getExtensionReceiverParameter(), resolvedCall2.getExtensionReceiver(), context2);
    }

    private final void checkReceiver(ReceiverParameterDescriptor receiverParameter, ReceiverValue receiverValue, CallCheckerContext context2) {
        if (receiverParameter == null || receiverValue == null) {
            return;
        }
        ExpressionReceiver expressionReceiver = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
        if (expressionReceiver == null) {
            return;
        }
        ExpressionReceiver expressionReceiverValue = expressionReceiver;
        KtExpression receiverExpression = expressionReceiverValue.getExpression();
        ResolutionContext<?> c = context2.getResolutionContext();
        KotlinType kotlinType = receiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType kotlinType2 = ((ExpressionReceiver)receiverValue).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        KotlinType kotlinType3 = ((ExpressionReceiver)receiverValue).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"getType(...)");
        RuntimeAssertionInfo assertionInfo = RuntimeAssertionInfo.Companion.create(kotlinType, kotlinType2, new RuntimeAssertionsDataFlowExtras(c, kotlinType3, receiverExpression));
        if (assertionInfo != null) {
            c.trace.record(JvmBindingContextSlices.RECEIVER_RUNTIME_ASSERTION_INFO, expressionReceiverValue, assertionInfo);
        }
    }
}

