/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContextForProvider;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.FirAnonymousUnusedParamChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentSet;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u00ab\u0001\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0006\u0010\u001c\u001a\u00020\u000e\u0012\u0006\u0010\u001d\u001a\u00020\u000e\u0012\u0006\u0010\u001e\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001f\u0010 B\u0019\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001f\u0010!J\u0010\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0004H\u0016J\b\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0006H\u0016J\b\u0010?\u001a\u00020<H\u0016J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\bH\u0016J\b\u0010B\u001a\u00020<H\u0016J\u0010\u0010C\u001a\u00020\u00012\u0006\u0010D\u001a\u00020\nH\u0016J\b\u0010E\u001a\u00020<H\u0016J\u0010\u0010F\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\fH\u0016J\b\u0010H\u001a\u00020<H\u0016J.\u0010I\u001a\u00020\u00012\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001b0K2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010L\u001a\u00020\u0001H\u0016J\b\u0010M\u001a\u00020\u0001H\u0016J\u0010\u0010-\u001a\u00020\u00012\u0006\u0010N\u001a\u00020\u0010H\u0016J\b\u0010O\u001a\u00020\u0001H\u0016J\u0010\u00101\u001a\u00020\u00012\u0006\u0010N\u001a\u00020\u0012H\u0016J\b\u0010P\u001a\u00020\u0001H\u0016J\u0010\u0010Q\u001a\u00020\u00012\u0006\u0010R\u001a\u00020\u0014H\u0016J\u0010\u0010S\u001a\u00020\u00012\u0006\u0010R\u001a\u00020\u0014H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010(\"\u0004\b)\u0010*R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006T"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/MutableCheckerContext;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextForProvider;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "callsOrAssignments", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getClassCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "annotationContainers", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "containingElements", "Lorg/jetbrains/kotlin/fir/FirElement;", "isContractBody", "", "inlineFunctionBodyContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "lambdaBodyContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;", "containingFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "suppressedDiagnostics", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentSet;", "", "allInfosSuppressed", "allWarningsSuppressed", "allErrorsSuppressed", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;Lkotlinx/collections/immutable/PersistentSet;ZZZ)V", "(Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;)V", "getContainingDeclarations", "()Ljava/util/List;", "getCallsOrAssignments", "getGetClassCalls", "getAnnotationContainers", "getContainingElements", "()Z", "setContractBody", "(Z)V", "getInlineFunctionBodyContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "setInlineFunctionBodyContext", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;)V", "getLambdaBodyContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;", "setLambdaBodyContext", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirAnonymousUnusedParamChecker$LambdaBodyContext;)V", "getContainingFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "setContainingFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "getSuppressedDiagnostics", "()Lkotlinx/collections/immutable/PersistentSet;", "addDeclaration", "declaration", "dropDeclaration", "", "addCallOrAssignment", "qualifiedAccessOrAnnotationCall", "dropCallOrAssignment", "addGetClassCall", "getClassCall", "dropGetClassCall", "addAnnotationContainer", "annotationContainer", "dropAnnotationContainer", "addElement", "element", "dropElement", "addSuppressedDiagnostics", "diagnosticNames", "", "enterContractBody", "exitContractBody", "context", "unsetInlineFunctionBodyContext", "unsetLambdaBodyContext", "enterFile", "file", "exitFile", "checkers"})
public final class MutableCheckerContext
extends CheckerContextForProvider {
    @NotNull
    private final List<FirDeclaration> containingDeclarations;
    @NotNull
    private final List<FirStatement> callsOrAssignments;
    @NotNull
    private final List<FirGetClassCall> getClassCalls;
    @NotNull
    private final List<FirAnnotationContainer> annotationContainers;
    @NotNull
    private final List<FirElement> containingElements;
    private boolean isContractBody;
    @Nullable
    private FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext;
    @Nullable
    private FirAnonymousUnusedParamChecker.LambdaBodyContext lambdaBodyContext;
    @Nullable
    private FirFile containingFile;
    @NotNull
    private final PersistentSet<String> suppressedDiagnostics;

    private MutableCheckerContext(List<FirDeclaration> containingDeclarations, List<FirStatement> callsOrAssignments, List<FirGetClassCall> getClassCalls, List<FirAnnotationContainer> annotationContainers, List<FirElement> containingElements, boolean isContractBody, FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext, FirAnonymousUnusedParamChecker.LambdaBodyContext lambdaBodyContext, FirFile containingFile, SessionHolder sessionHolder, ReturnTypeCalculator returnTypeCalculator, PersistentSet<String> suppressedDiagnostics, boolean allInfosSuppressed, boolean allWarningsSuppressed, boolean allErrorsSuppressed) {
        super(sessionHolder, returnTypeCalculator, allInfosSuppressed, allWarningsSuppressed, allErrorsSuppressed);
        this.containingDeclarations = containingDeclarations;
        this.callsOrAssignments = callsOrAssignments;
        this.getClassCalls = getClassCalls;
        this.annotationContainers = annotationContainers;
        this.containingElements = containingElements;
        this.isContractBody = isContractBody;
        this.inlineFunctionBodyContext = inlineFunctionBodyContext;
        this.lambdaBodyContext = lambdaBodyContext;
        this.containingFile = containingFile;
        this.suppressedDiagnostics = suppressedDiagnostics;
    }

    @Override
    @NotNull
    public List<FirDeclaration> getContainingDeclarations() {
        return this.containingDeclarations;
    }

    @Override
    @NotNull
    public List<FirStatement> getCallsOrAssignments() {
        return this.callsOrAssignments;
    }

    @Override
    @NotNull
    public List<FirGetClassCall> getGetClassCalls() {
        return this.getClassCalls;
    }

    @Override
    @NotNull
    public List<FirAnnotationContainer> getAnnotationContainers() {
        return this.annotationContainers;
    }

    @Override
    @NotNull
    public List<FirElement> getContainingElements() {
        return this.containingElements;
    }

    @Override
    public boolean isContractBody() {
        return this.isContractBody;
    }

    public void setContractBody(boolean bl) {
        this.isContractBody = bl;
    }

    @Override
    @Nullable
    public FirInlineDeclarationChecker.InlineFunctionBodyContext getInlineFunctionBodyContext() {
        return this.inlineFunctionBodyContext;
    }

    public void setInlineFunctionBodyContext(@Nullable FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext) {
        this.inlineFunctionBodyContext = inlineFunctionBodyContext;
    }

    @Override
    @Nullable
    public FirAnonymousUnusedParamChecker.LambdaBodyContext getLambdaBodyContext() {
        return this.lambdaBodyContext;
    }

    public void setLambdaBodyContext(@Nullable FirAnonymousUnusedParamChecker.LambdaBodyContext lambdaBodyContext) {
        this.lambdaBodyContext = lambdaBodyContext;
    }

    @Override
    @Nullable
    public FirFile getContainingFile() {
        return this.containingFile;
    }

    public void setContainingFile(@Nullable FirFile firFile) {
        this.containingFile = firFile;
    }

    @NotNull
    public PersistentSet<String> getSuppressedDiagnostics() {
        return this.suppressedDiagnostics;
    }

    public MutableCheckerContext(@NotNull SessionHolder sessionHolder, @NotNull ReturnTypeCalculator returnTypeCalculator) {
        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
        Intrinsics.checkNotNullParameter((Object)returnTypeCalculator, (String)"returnTypeCalculator");
        this(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), false, null, null, null, sessionHolder, returnTypeCalculator, CheckerContextForProvider.Companion.getGloballySuppressedDiagnostics(sessionHolder.getSession()), false, false, false);
    }

    @Override
    @NotNull
    public MutableCheckerContext addDeclaration(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.getContainingDeclarations().add(declaration);
        return this;
    }

    @Override
    public void dropDeclaration() {
        CollectionsKt.removeLast(this.getContainingDeclarations());
    }

    @Override
    @NotNull
    public MutableCheckerContext addCallOrAssignment(@NotNull FirStatement qualifiedAccessOrAnnotationCall) {
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessOrAnnotationCall, (String)"qualifiedAccessOrAnnotationCall");
        this.getCallsOrAssignments().add(qualifiedAccessOrAnnotationCall);
        return this;
    }

    @Override
    public void dropCallOrAssignment() {
        CollectionsKt.removeLast(this.getCallsOrAssignments());
    }

    @Override
    @NotNull
    public MutableCheckerContext addGetClassCall(@NotNull FirGetClassCall getClassCall) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        this.getGetClassCalls().add(getClassCall);
        return this;
    }

    @Override
    public void dropGetClassCall() {
        CollectionsKt.removeLast(this.getGetClassCalls());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addAnnotationContainer(@NotNull FirAnnotationContainer annotationContainer) {
        Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
        this.getAnnotationContainers().add(annotationContainer);
        return this;
    }

    @Override
    public void dropAnnotationContainer() {
        CollectionsKt.removeLast(this.getAnnotationContainers());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addElement(@NotNull FirElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean bl2 = bl = CollectionsKt.lastOrNull(this.getContainingElements()) != element;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.getContainingElements().add(element);
        return this;
    }

    @Override
    public void dropElement() {
        CollectionsKt.removeLast(this.getContainingElements());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addSuppressedDiagnostics(@NotNull Collection<String> diagnosticNames, boolean allInfosSuppressed, boolean allWarningsSuppressed, boolean allErrorsSuppressed) {
        Intrinsics.checkNotNullParameter(diagnosticNames, (String)"diagnosticNames");
        if (diagnosticNames.isEmpty()) {
            return this;
        }
        return new MutableCheckerContext(this.getContainingDeclarations(), this.getCallsOrAssignments(), this.getGetClassCalls(), this.getAnnotationContainers(), this.getContainingElements(), this.isContractBody(), this.getInlineFunctionBodyContext(), this.getLambdaBodyContext(), this.getContainingFile(), this.getSessionHolder(), this.getReturnTypeCalculator(), this.getSuppressedDiagnostics().addAll(diagnosticNames), this.getAllInfosSuppressed() || allInfosSuppressed, this.getAllWarningsSuppressed() || allWarningsSuppressed, this.getAllErrorsSuppressed() || allErrorsSuppressed);
    }

    @Override
    @NotNull
    public CheckerContextForProvider enterContractBody() {
        if (!(!this.isContractBody())) {
            throw new IllegalStateException("Check failed.");
        }
        this.setContractBody(true);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider exitContractBody() {
        if (!this.isContractBody()) {
            throw new IllegalStateException("Check failed.");
        }
        this.setContractBody(false);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider setInlineFunctionBodyContext(@NotNull FirInlineDeclarationChecker.InlineFunctionBodyContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.setInlineFunctionBodyContext(context);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider unsetInlineFunctionBodyContext() {
        this.setInlineFunctionBodyContext(null);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider setLambdaBodyContext(@NotNull FirAnonymousUnusedParamChecker.LambdaBodyContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.setLambdaBodyContext(context);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider unsetLambdaBodyContext() {
        this.setLambdaBodyContext(null);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider enterFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.setContainingFile(file2);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider exitFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.setContainingFile(file2);
        return this;
    }
}

