/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.DelicateScopeAPI;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u001c\u0010\u0012\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0013H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirLazyNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "existingNames", "", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;Ljava/util/List;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "processClassifiersByNameWithSubstitution", "", "name", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "getClassifierNames", "", "getCallableNames", "withReplacedSessionOrNull", "newSession", "newScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "providers"})
public final class FirLazyNestedClassifierScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ClassId classId;
    @NotNull
    private final List<Name> existingNames;

    public FirLazyNestedClassifierScope(@NotNull FirSession session2, @NotNull ClassId classId, @NotNull List<Name> existingNames) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter(existingNames, (String)"existingNames");
        this.session = session2;
        this.classId = classId;
        this.existingNames = existingNames;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        if (!this.existingNames.contains(name2)) {
            return;
        }
        ClassId child = this.classId.createNestedClassId(name2);
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.session).getClassLikeSymbolByClassId(child);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
        processor.invoke(symbol, (Object)ConeSubstitutor.Empty.INSTANCE);
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return CollectionsKt.toSet((Iterable)this.existingNames);
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @DelicateScopeAPI
    @Nullable
    public FirLazyNestedClassifierScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter((Object)newSession, (String)"newSession");
        Intrinsics.checkNotNullParameter((Object)newScopeSession, (String)"newScopeSession");
        return new FirLazyNestedClassifierScope(newSession, this.classId, this.existingNames);
    }
}

