/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleComparator;

public final class DoubleArrays {
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final double[] DEFAULT_EMPTY_ARRAY = new double[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<double[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static double[] forceCapacity(double[] array, int length, int preserve) {
        double[] t = new double[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static void ensureOffsetLength(double[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void insertionSort(double[] a, int from2, int to, DoubleComparator comp) {
        int i = from2;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void insertionSort(double[] a, int from2, int to) {
        int i = from2;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (Double.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void mergeSort(double[] a, int from2, int to, double[] supp) {
        int len = to - from2;
        if (len < 16) {
            DoubleArrays.insertionSort(a, from2, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from2 + to >>> 1;
        DoubleArrays.mergeSort(supp, from2, mid, a);
        DoubleArrays.mergeSort(supp, mid, to, a);
        if (Double.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && Double.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(double[] a, int from2, int to) {
        DoubleArrays.mergeSort(a, from2, to, (double[])null);
    }

    public static void mergeSort(double[] a, int from2, int to, DoubleComparator comp, double[] supp) {
        int len = to - from2;
        if (len < 16) {
            DoubleArrays.insertionSort(a, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from2 + to >>> 1;
        DoubleArrays.mergeSort(supp, from2, mid, comp, a);
        DoubleArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(double[] a, int from2, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a, from2, to, comp, null);
    }

    public static void stableSort(double[] a, int from2, int to) {
        DoubleArrays.mergeSort(a, from2, to);
    }

    public static void stableSort(double[] a) {
        DoubleArrays.stableSort(a, 0, a.length);
    }

    public static void stableSort(double[] a, int from2, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a, from2, to, comp);
    }

    public static void stableSort(double[] a, DoubleComparator comp) {
        DoubleArrays.stableSort(a, 0, a.length, comp);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(double[] a, double[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

