/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;

public final class ObjectArrays {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Object[] DEFAULT_EMPTY_ARRAY = new Object[0];
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private static <K> K[] newArray(K[] prototype, int length) {
        Class<?> klass = prototype.getClass();
        if (klass == Object[].class) {
            return length == 0 ? EMPTY_ARRAY : new Object[length];
        }
        return (Object[])Array.newInstance(klass.getComponentType(), length);
    }

    public static <K> K[] forceCapacity(K[] array, int length, int preserve) {
        K[] t = ObjectArrays.newArray(array, length);
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static <K> void ensureOffsetLength(K[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    public static <K> void stableSort(K[] a, int from2, int to) {
        java.util.Arrays.sort(a, from2, to);
    }

    public static <K> void stableSort(K[] a) {
        ObjectArrays.stableSort(a, 0, a.length);
    }

    public static <K> void stableSort(K[] a, int from2, int to, Comparator<K> comp) {
        java.util.Arrays.sort(a, from2, to, comp);
    }

    public static <K> void stableSort(K[] a, Comparator<K> comp) {
        ObjectArrays.stableSort(a, 0, a.length, comp);
    }

    private static final class ArrayHashStrategy<K>
    implements Hash.Strategy<K[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(K[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(K[] a, K[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

