/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.util.Arrays;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGeneratorKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0004 !\"#B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJi\u0010\u0013\u001a\u00020\u00032_\u0010\u0014\u001a[\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u001b\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001c\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u001b0\u0015j\u0002`\u001dH\u0007J\u0012\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007R\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator;", "", "markdownText", "", "root", "Lorg/intellij/markdown/ast/ASTNode;", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "includeSrcPositions", "", "(Ljava/lang/String;Lorg/intellij/markdown/ast/ASTNode;Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;Z)V", "providers", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "(Ljava/lang/String;Lorg/intellij/markdown/ast/ASTNode;Ljava/util/Map;Z)V", "htmlString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "generateHtml", "customizer", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "node", "", "tagName", "", "attributes", "Lorg/intellij/markdown/html/AttributesCustomizer;", "tagRenderer", "Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;", "Companion", "DefaultTagRenderer", "HtmlGeneratingVisitor", "TagRenderer", "intellij-markdown"})
public final class HtmlGenerator {
    private final StringBuilder htmlString;
    private final String markdownText;
    private final ASTNode root;
    private final Map<IElementType, GeneratingProvider> providers;
    private final boolean includeSrcPositions;
    @NotNull
    private static final String SRC_ATTRIBUTE_NAME = "md-src-pos";
    public static final Companion Companion = new Companion(null);

    @Deprecated(message="To be removed, pass custom visitor instead", replaceWith=@ReplaceWith(imports={}, expression="generateHtml(HtmlGeneratingVisitor)"))
    @NotNull
    public final String generateHtml(@NotNull Function3<? super ASTNode, ? super CharSequence, ? super Iterable<? extends CharSequence>, ? extends Iterable<? extends CharSequence>> customizer) {
        Intrinsics.checkParameterIsNotNull(customizer, (String)"customizer");
        new HtmlGeneratingVisitor(new DefaultTagRenderer(customizer, this.includeSrcPositions)).visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"htmlString.toString()");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final String generateHtml(@NotNull TagRenderer tagRenderer) {
        Intrinsics.checkParameterIsNotNull((Object)tagRenderer, (String)"tagRenderer");
        new HtmlGeneratingVisitor(tagRenderer).visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"htmlString.toString()");
        return string;
    }

    public static /* synthetic */ String generateHtml$default(HtmlGenerator htmlGenerator, TagRenderer tagRenderer, int n, Object object) {
        if ((n & 1) != 0) {
            tagRenderer = new DefaultTagRenderer(HtmlGeneratorKt.getDUMMY_ATTRIBUTES_CUSTOMIZER(), htmlGenerator.includeSrcPositions);
        }
        return htmlGenerator.generateHtml(tagRenderer);
    }

    @JvmOverloads
    @NotNull
    public final String generateHtml() {
        return HtmlGenerator.generateHtml$default(this, null, 1, null);
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull Map<IElementType, ? extends GeneratingProvider> providers, boolean includeSrcPositions) {
        Intrinsics.checkParameterIsNotNull((Object)markdownText, (String)"markdownText");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(providers, (String)"providers");
        this.markdownText = markdownText;
        this.root = root;
        this.providers = providers;
        this.includeSrcPositions = includeSrcPositions;
        this.htmlString = new StringBuilder();
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, aSTNode, map, bl);
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull MarkdownFlavourDescriptor flavour, boolean includeSrcPositions) {
        Intrinsics.checkParameterIsNotNull((Object)markdownText, (String)"markdownText");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)flavour, (String)"flavour");
        this(markdownText, root, flavour.createHtmlGeneratingProviders(LinkMap.Builder.buildLinkMap(root, markdownText), null), includeSrcPositions);
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, MarkdownFlavourDescriptor markdownFlavourDescriptor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, aSTNode, markdownFlavourDescriptor, bl);
    }

    static {
        SRC_ATTRIBUTE_NAME = SRC_ATTRIBUTE_NAME;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ=\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\b2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u000f\"\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/ast/visitors/RecursiveVisitor;", "tagRenderer", "Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;", "(Lorg/intellij/markdown/html/HtmlGenerator;Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;)V", "consumeHtml", "", "html", "", "consumeTagClose", "tagName", "consumeTagOpen", "node", "Lorg/intellij/markdown/ast/ASTNode;", "attributes", "", "autoClose", "", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)V", "visitLeaf", "visitNode", "intellij-markdown"})
    public final class HtmlGeneratingVisitor
    extends RecursiveVisitor {
        private final TagRenderer tagRenderer;

        @Override
        public void visitNode(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            GeneratingProvider generatingProvider = (GeneratingProvider)HtmlGenerator.this.providers.get(node.getType());
            if (generatingProvider != null) {
                generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
            } else {
                ASTNodeKt.acceptChildren(node, this);
            }
        }

        public final void visitLeaf(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            GeneratingProvider generatingProvider = (GeneratingProvider)HtmlGenerator.this.providers.get(node.getType());
            if (generatingProvider != null) {
                generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
            } else {
                this.consumeHtml(org.intellij.markdown.html.HtmlGenerator$Companion.leafText$default(Companion, HtmlGenerator.this.markdownText, node, false, 4, null));
            }
        }

        public final void consumeTagOpen(@NotNull ASTNode node, @NotNull CharSequence tagName, @NotNull CharSequence[] attributes, boolean autoClose) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            CharSequence[] charSequenceArray = Arrays.copyOf(attributes, attributes.length);
            boolean bl = autoClose;
            HtmlGenerator.this.htmlString.append(this.tagRenderer.openTag(node, tagName, charSequenceArray, bl));
        }

        public static /* synthetic */ void consumeTagOpen$default(HtmlGeneratingVisitor htmlGeneratingVisitor, ASTNode aSTNode, CharSequence charSequence, CharSequence[] charSequenceArray, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, bl);
        }

        public final void consumeTagClose(@NotNull CharSequence tagName) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            HtmlGenerator.this.htmlString.append(this.tagRenderer.closeTag(tagName));
        }

        public final void consumeHtml(@NotNull CharSequence html) {
            Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
            HtmlGenerator.this.htmlString.append(this.tagRenderer.printHtml(html));
        }

        public HtmlGeneratingVisitor(TagRenderer tagRenderer) {
            Intrinsics.checkParameterIsNotNull((Object)tagRenderer, (String)"tagRenderer");
            this.tagRenderer = tagRenderer;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001Bn\u0012_\u0010\u0002\u001a[\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\b0\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n0\u0003j\u0002`\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J=\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0016\"\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0016Rm\u0010\u0002\u001a[\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\b0\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n0\u0003j\u0002`\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$DefaultTagRenderer;", "Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;", "customizer", "Lkotlin/Function3;", "Lorg/intellij/markdown/ast/ASTNode;", "Lkotlin/ParameterName;", "name", "node", "", "tagName", "", "attributes", "Lorg/intellij/markdown/html/AttributesCustomizer;", "includeSrcPositions", "", "(Lkotlin/jvm/functions/Function3;Z)V", "getCustomizer", "()Lkotlin/jvm/functions/Function3;", "getIncludeSrcPositions", "()Z", "closeTag", "openTag", "", "autoClose", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)Ljava/lang/CharSequence;", "printHtml", "html", "intellij-markdown"})
    public static class DefaultTagRenderer
    implements TagRenderer {
        @NotNull
        private final Function3<ASTNode, CharSequence, Iterable<? extends CharSequence>, Iterable<CharSequence>> customizer;
        private final boolean includeSrcPositions;

        @Override
        @NotNull
        public CharSequence openTag(@NotNull ASTNode node, @NotNull CharSequence tagName, @NotNull CharSequence[] attributes, boolean autoClose) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl4 = false;
            $this$buildString.append("" + '<' + tagName);
            for (CharSequence attribute : (Iterable)this.customizer.invoke((Object)node, (Object)tagName, (Object)ArraysKt.asIterable((Object[])attributes))) {
                if (attribute == null) continue;
                $this$buildString.append("" + ' ' + attribute);
            }
            if (this.includeSrcPositions) {
                $this$buildString.append("" + ' ' + Companion.getSrcPosAttribute(node));
            }
            if (autoClose) {
                $this$buildString.append(" />");
            } else {
                $this$buildString.append(">");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @Override
        @NotNull
        public CharSequence closeTag(@NotNull CharSequence tagName) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            return "</" + tagName + '>';
        }

        @Override
        @NotNull
        public CharSequence printHtml(@NotNull CharSequence html) {
            Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
            return html;
        }

        @NotNull
        protected final Function3<ASTNode, CharSequence, Iterable<? extends CharSequence>, Iterable<CharSequence>> getCustomizer() {
            return this.customizer;
        }

        protected final boolean getIncludeSrcPositions() {
            return this.includeSrcPositions;
        }

        public DefaultTagRenderer(@NotNull Function3<? super ASTNode, ? super CharSequence, ? super Iterable<? extends CharSequence>, ? extends Iterable<? extends CharSequence>> customizer, boolean includeSrcPositions) {
            Intrinsics.checkParameterIsNotNull(customizer, (String)"customizer");
            this.customizer = customizer;
            this.includeSrcPositions = includeSrcPositions;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&J?\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\t\"\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bH&\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a8\u0006\u000f"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;", "", "closeTag", "", "tagName", "openTag", "node", "Lorg/intellij/markdown/ast/ASTNode;", "attributes", "", "autoClose", "", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)Ljava/lang/CharSequence;", "printHtml", "html", "intellij-markdown"})
    public static interface TagRenderer {
        @NotNull
        public CharSequence openTag(@NotNull ASTNode var1, @NotNull CharSequence var2, @NotNull CharSequence[] var3, boolean var4);

        @NotNull
        public CharSequence closeTag(@NotNull CharSequence var1);

        @NotNull
        public CharSequence printHtml(@NotNull CharSequence var1);

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ CharSequence openTag$default(TagRenderer tagRenderer, ASTNode aSTNode, CharSequence charSequence, CharSequence[] charSequenceArray, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openTag");
                }
                if ((n & 8) != 0) {
                    bl = false;
                }
                return tagRenderer.openTag(aSTNode, charSequence, charSequenceArray, bl);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$Companion;", "", "()V", "SRC_ATTRIBUTE_NAME", "", "getSRC_ATTRIBUTE_NAME", "()Ljava/lang/String;", "getSrcPosAttribute", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "leafText", "text", "replaceEscapesAndEntities", "", "trimIndents", "indent", "", "intellij-markdown"})
    public static final class Companion {
        @NotNull
        public final String getSRC_ATTRIBUTE_NAME() {
            return SRC_ATTRIBUTE_NAME;
        }

        @NotNull
        public final CharSequence leafText(@NotNull String text, @NotNull ASTNode node, boolean replaceEscapesAndEntities) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
                return "";
            }
            return EntityConverter.INSTANCE.replaceEntities(ASTUtilKt.getTextInNode(node, text), replaceEscapesAndEntities, replaceEscapesAndEntities);
        }

        public static /* synthetic */ CharSequence leafText$default(Companion companion, String string, ASTNode aSTNode, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.leafText(string, aSTNode, bl);
        }

        @NotNull
        public final CharSequence getSrcPosAttribute(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.getSRC_ATTRIBUTE_NAME() + "=\"" + node.getStartOffset() + ".." + node.getEndOffset() + '\"';
        }

        @NotNull
        public final CharSequence trimIndents(@NotNull CharSequence text, int indent) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (indent == 0) {
                return text;
            }
            StringBuilder buffer = new StringBuilder();
            int lastFlushed = 0;
            for (int offset = 0; offset < text.length(); ++offset) {
                if (offset != 0 && text.charAt(offset - 1) != '\n') continue;
                buffer.append(text.subSequence(lastFlushed, offset));
                int indentEaten = 0;
                block5: while (indentEaten < indent && offset < text.length()) {
                    switch (text.charAt(offset)) {
                        case ' ': {
                            ++indentEaten;
                            break;
                        }
                        case '\t': {
                            indentEaten += 4 - indentEaten % 4;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    ++offset;
                }
                if (indentEaten > indent) {
                    buffer.append(StringsKt.repeat((CharSequence)" ", (int)(indentEaten - indent)));
                }
                lastFlushed = offset;
            }
            buffer.append(text.subSequence(lastFlushed, text.length()));
            return buffer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

