/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.constraints;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.CommonMarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 &2\u00020\u0001:\u0002&'B'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00002\f\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0016J(\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u0018H\u0014J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0001H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\u0004\u0018\u00010\u00002\n\u0010\u0016\u001a\u00060\u0017R\u00020\u0018H\u0002J\u0016\u0010%\u001a\u0004\u0018\u00010\u00002\n\u0010\u0016\u001a\u00060\u0017R\u00020\u0018H\u0002R\u0014\u0010\u000b\u001a\u00020\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "indents", "", "types", "", "isExplicit", "", "charsEaten", "", "([I[C[ZI)V", "base", "getBase", "()Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "getCharsEaten", "()I", "indent", "getIndent", "()[Z", "getTypes", "()[C", "addModifierIfNeeded", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "applyToNextLine", "containsListMarkers", "", "upToIndex", "createNewConstraints", "fetchListMarker", "Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$ListMarkerInfo;", "startsWith", "other", "toString", "", "tryAddBlockQuote", "tryAddListItem", "Companion", "ListMarkerInfo", "intellij-markdown"})
public class CommonMarkdownConstraints
implements MarkdownConstraints {
    private final int[] indents;
    @NotNull
    private final char[] types;
    @NotNull
    private final boolean[] isExplicit;
    private final int charsEaten;
    @NotNull
    private static final CommonMarkdownConstraints BASE;
    public static final char BQ_CHAR = '>';
    public static final Companion Companion;

    @NotNull
    protected CommonMarkdownConstraints getBase() {
        return BASE;
    }

    @NotNull
    protected CommonMarkdownConstraints createNewConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkParameterIsNotNull((Object)indents, (String)"indents");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)isExplicit, (String)"isExplicit");
        return new CommonMarkdownConstraints(indents, types, isExplicit, charsEaten);
    }

    @Override
    public int getIndent() {
        Integer n = ArraysKt.lastOrNull((int[])this.indents);
        return n != null ? n : 0;
    }

    @Override
    public boolean startsWith(@NotNull MarkdownConstraints other) {
        boolean bl;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            if (!(other instanceof CommonMarkdownConstraints)) {
                return false;
            }
            int n = this.indents.length;
            int m = ((CommonMarkdownConstraints)other).indents.length;
            if (n < m) {
                return false;
            }
            Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)m);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$none$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.getTypes()[it] != other.getTypes()[it])) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean containsListMarkers(int upToIndex) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)upToIndex);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.getTypes()[it] != '>' && this.isExplicit()[it])) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public CommonMarkdownConstraints addModifierIfNeeded(@Nullable LookaheadText.Position pos) {
        if (pos == null || pos.getOffsetInCurrentLine() == -1) {
            return null;
        }
        if (HorizontalRuleProvider.Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine())) {
            return null;
        }
        CommonMarkdownConstraints commonMarkdownConstraints = this.tryAddListItem(pos);
        if (commonMarkdownConstraints == null) {
            commonMarkdownConstraints = this.tryAddBlockQuote(pos);
        }
        return commonMarkdownConstraints;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommonMarkdownConstraints applyToNextLine(@Nullable LookaheadText.Position pos) {
        void indexPrev;
        if (pos == null) {
            return this.getBase();
        }
        boolean bl = pos.getOffsetInCurrentLine() == -1;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CommonMarkdownConstraints$applyToNextLine$22 = false;
            String $i$a$-assert-CommonMarkdownConstraints$applyToNextLine$22 = "given " + pos;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CommonMarkdownConstraints$applyToNextLine$22));
        }
        String line = pos.getCurrentLine();
        int prevN = this.indents.length;
        Ref.IntRef $i$a$-assert-CommonMarkdownConstraints$applyToNextLine$22 = new Ref.IntRef();
        $i$a$-assert-CommonMarkdownConstraints$applyToNextLine$22.element = 0;
        Function1 getBlockQuoteIndent2 = (Function1)new Function1<Integer, Integer>(line){
            final /* synthetic */ String $line;

            @Nullable
            public final Integer invoke(int startOffset) {
                int blockQuoteIndent;
                int offset = startOffset;
                for (blockQuoteIndent = 0; blockQuoteIndent < 3 && offset < this.$line.length() && this.$line.charAt(offset) == ' '; ++blockQuoteIndent, ++offset) {
                }
                return offset < this.$line.length() && this.$line.charAt(offset) == '>' ? Integer.valueOf(blockQuoteIndent + 1) : null;
            }
            {
                this.$line = string;
                super(1);
            }
        };
        Function1 fillMaybeBlockquoteAndListIndents2 = (Function1)new Function1<CommonMarkdownConstraints, CommonMarkdownConstraints>(this, (Ref.IntRef)indexPrev, prevN, line, getBlockQuoteIndent2){
            final /* synthetic */ CommonMarkdownConstraints this$0;
            final /* synthetic */ Ref.IntRef $indexPrev;
            final /* synthetic */ int $prevN;
            final /* synthetic */ String $line;
            final /* synthetic */ Function1 $getBlockQuoteIndent;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CommonMarkdownConstraints invoke(@NotNull CommonMarkdownConstraints constraints) {
                int bonusForTheBlockquote;
                int deltaIndent;
                void totalSpaces;
                void offset;
                void spacesSeen;
                Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
                if (this.$indexPrev.element >= this.$prevN) {
                    return constraints;
                }
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = MarkdownConstraintsKt.getCharsEaten(constraints, this.$line);
                Ref.IntRef intRef2 = new Ref.IntRef();
                intRef2.element = 0;
                Ref.IntRef intRef3 = new Ref.IntRef();
                intRef3.element = 0;
                Function1 hasKMoreSpaces2 = (Function1)new Function1<Integer, Boolean>(this, (Ref.IntRef)spacesSeen, (Ref.IntRef)offset, (Ref.IntRef)totalSpaces){
                    final /* synthetic */ applyToNextLine.fillMaybeBlockquoteAndListIndents.1 this$0;
                    final /* synthetic */ Ref.IntRef $spacesSeen;
                    final /* synthetic */ Ref.IntRef $offset;
                    final /* synthetic */ Ref.IntRef $totalSpaces;

                    public final boolean invoke(int k) {
                        boolean bl;
                        int oldSpacesSeen = this.$spacesSeen.element;
                        int oldOffset = this.$offset.element;
                        block4: while (this.$spacesSeen.element < k && this.$offset.element < this.this$0.$line.length()) {
                            int n;
                            switch (this.this$0.$line.charAt(this.$offset.element)) {
                                case ' ': {
                                    n = 1;
                                    break;
                                }
                                case '\t': {
                                    n = 4 - this.$totalSpaces.element % 4;
                                    break;
                                }
                                default: {
                                    break block4;
                                }
                            }
                            int deltaSpaces = n;
                            this.$spacesSeen.element += deltaSpaces;
                            this.$totalSpaces.element += deltaSpaces;
                            int n2 = this.$offset.element;
                            this.$offset.element = n2 + 1;
                        }
                        if (this.$offset.element == this.this$0.$line.length()) {
                            this.$spacesSeen.element = Integer.MAX_VALUE;
                        }
                        if (k <= this.$spacesSeen.element) {
                            this.$spacesSeen.element -= k;
                            bl = true;
                        } else {
                            this.$offset.element = oldOffset;
                            this.$spacesSeen.element = oldSpacesSeen;
                            bl = false;
                        }
                        return bl;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$spacesSeen = intRef;
                        this.$offset = intRef2;
                        this.$totalSpaces = intRef3;
                        super(1);
                    }
                };
                Integer bqIndent = null;
                if (this.this$0.getTypes()[this.$indexPrev.element] == '>') {
                    Integer n = (Integer)this.$getBlockQuoteIndent.invoke((Object)offset.element);
                    if (n == null) {
                        return constraints;
                    }
                    bqIndent = (int)n;
                    offset.element += bqIndent.intValue();
                    int n2 = this.$indexPrev.element;
                    this.$indexPrev.element = n2 + 1;
                } else {
                    bqIndent = null;
                }
                int oldIndexPrev = this.$indexPrev.element;
                while (this.$indexPrev.element < this.$prevN && this.this$0.getTypes()[this.$indexPrev.element] != '>' && ((Boolean)hasKMoreSpaces2.invoke((Object)(deltaIndent = CommonMarkdownConstraints.access$getIndents$p(this.this$0)[this.$indexPrev.element] - (this.$indexPrev.element == 0 ? 0 : CommonMarkdownConstraints.access$getIndents$p(this.this$0)[this.$indexPrev.element - 1])))).booleanValue()) {
                    int n = this.$indexPrev.element;
                    this.$indexPrev.element = n + 1;
                }
                CommonMarkdownConstraints result = constraints;
                if (bqIndent != null) {
                    bonusForTheBlockquote = (Boolean)hasKMoreSpaces2.invoke((Object)1) != false ? 1 : 0;
                    result = org.intellij.markdown.parser.constraints.CommonMarkdownConstraints$Companion.access$create(CommonMarkdownConstraints.Companion, result, bqIndent + bonusForTheBlockquote, '>', true, offset.element);
                }
                bonusForTheBlockquote = oldIndexPrev;
                int n = this.$indexPrev.element;
                while (bonusForTheBlockquote < n) {
                    void index;
                    int deltaIndent2 = CommonMarkdownConstraints.access$getIndents$p(this.this$0)[index] - (index == false ? 0 : CommonMarkdownConstraints.access$getIndents$p(this.this$0)[index - true]);
                    result = org.intellij.markdown.parser.constraints.CommonMarkdownConstraints$Companion.access$create(CommonMarkdownConstraints.Companion, result, deltaIndent2, this.this$0.getTypes()[index], false, offset.element);
                    ++index;
                }
                return result;
            }
            {
                this.this$0 = commonMarkdownConstraints;
                this.$indexPrev = intRef;
                this.$prevN = n;
                this.$line = string;
                this.$getBlockQuoteIndent = function1;
                super(1);
            }
        };
        CommonMarkdownConstraints result = this.getBase();
        CommonMarkdownConstraints nextConstraints;
        while (!Intrinsics.areEqual((Object)(nextConstraints = (CommonMarkdownConstraints)fillMaybeBlockquoteAndListIndents2.invoke((Object)result)), (Object)result)) {
            result = nextConstraints;
        }
        return result;
    }

    @Nullable
    protected ListMarkerInfo fetchListMarker(@NotNull LookaheadText.Position pos) {
        char c;
        int offset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        char c2 = pos.getChar();
        if (c2 == '*' || c2 == '-' || c2 == '+') {
            return new ListMarkerInfo(1, c2, 1);
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length() && '0' <= (c = line.charAt(offset)) && '9' >= c; ++offset) {
        }
        return offset > pos.getOffsetInCurrentLine() && offset - pos.getOffsetInCurrentLine() <= 9 && offset < line.length() && (line.charAt(offset) == '.' || line.charAt(offset) == ')') ? new ListMarkerInfo(offset + 1 - pos.getOffsetInCurrentLine(), line.charAt(offset), offset + 1 - pos.getOffsetInCurrentLine()) : null;
    }

    private final CommonMarkdownConstraints tryAddListItem(LookaheadText.Position pos) {
        int n;
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        int n2 = spacesBefore = offset > 0 && line.charAt(offset - 1) == '\t' ? (4 - this.getIndent() % 4) % 4 : 0;
        while (offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3) {
            ++spacesBefore;
            ++offset;
        }
        if (offset == line.length()) {
            return null;
        }
        LookaheadText.Position position = pos.nextPosition(offset - pos.getOffsetInCurrentLine());
        if (position == null) {
            Intrinsics.throwNpe();
        }
        ListMarkerInfo listMarkerInfo = this.fetchListMarker(position);
        if (listMarkerInfo == null) {
            return null;
        }
        ListMarkerInfo markerInfo = listMarkerInfo;
        int spacesAfter = 0;
        int markerEndOffset = offset += markerInfo.getMarkerLength();
        block5: while (offset < line.length()) {
            switch (line.charAt(offset)) {
                case ' ': {
                    ++spacesAfter;
                    break;
                }
                case '\t': {
                    spacesAfter += 4 - spacesAfter % 4;
                    break;
                }
                default: {
                    break block5;
                }
            }
            ++offset;
        }
        if (1 <= (n = spacesAfter) && 4 >= n && offset < line.length()) {
            return CommonMarkdownConstraints.Companion.create(this, spacesBefore + markerInfo.getMarkerIndent() + spacesAfter, markerInfo.getMarkerType(), true, offset);
        }
        if (spacesAfter >= 5 && offset < line.length() || offset == line.length()) {
            n = markerEndOffset + 1;
            boolean bl = true;
            char c = markerInfo.getMarkerType();
            int n3 = spacesBefore + markerInfo.getMarkerIndent() + 1;
            CommonMarkdownConstraints commonMarkdownConstraints = this;
            Companion companion = Companion;
            boolean bl2 = false;
            int n4 = Math.min(offset, n);
            return companion.create(commonMarkdownConstraints, n3, c, bl, n4);
        }
        return null;
    }

    private final CommonMarkdownConstraints tryAddBlockQuote(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        for (spacesBefore = 0; offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3; ++spacesBefore, ++offset) {
        }
        if (offset == line.length() || line.charAt(offset) != '>') {
            return null;
        }
        int spacesAfter = 0;
        if (++offset >= line.length() || line.charAt(offset) == ' ' || line.charAt(offset) == '\t') {
            spacesAfter = 1;
            if (offset < line.length()) {
                ++offset;
            }
        }
        return CommonMarkdownConstraints.Companion.create(this, spacesBefore + 1 + spacesAfter, '>', true, offset);
    }

    @NotNull
    public String toString() {
        char[] cArray = this.getTypes();
        StringBuilder stringBuilder = new StringBuilder().append("MdConstraints: ");
        boolean bl = false;
        String string = new String(cArray);
        return stringBuilder.append(string).append("(").append(this.getIndent()).append(")").toString();
    }

    @Override
    @NotNull
    public char[] getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public boolean[] isExplicit() {
        return this.isExplicit;
    }

    @Override
    public int getCharsEaten() {
        return this.charsEaten;
    }

    protected CommonMarkdownConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkParameterIsNotNull((Object)indents, (String)"indents");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)isExplicit, (String)"isExplicit");
        this.indents = indents;
        this.types = types;
        this.isExplicit = isExplicit;
        this.charsEaten = charsEaten;
    }

    static {
        Companion = new Companion(null);
        BASE = new CommonMarkdownConstraints(new int[0], new char[0], new boolean[0], 0);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$ListMarkerInfo;", "", "markerLength", "", "markerType", "", "markerIndent", "(ICI)V", "getMarkerIndent", "()I", "getMarkerLength", "getMarkerType", "()C", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij-markdown"})
    protected static final class ListMarkerInfo {
        private final int markerLength;
        private final char markerType;
        private final int markerIndent;

        public final int getMarkerLength() {
            return this.markerLength;
        }

        public final char getMarkerType() {
            return this.markerType;
        }

        public final int getMarkerIndent() {
            return this.markerIndent;
        }

        public ListMarkerInfo(int markerLength, char markerType, int markerIndent) {
            this.markerLength = markerLength;
            this.markerType = markerType;
            this.markerIndent = markerIndent;
        }

        public final int component1() {
            return this.markerLength;
        }

        public final char component2() {
            return this.markerType;
        }

        public final int component3() {
            return this.markerIndent;
        }

        @NotNull
        public final ListMarkerInfo copy(int markerLength, char markerType, int markerIndent) {
            return new ListMarkerInfo(markerLength, markerType, markerIndent);
        }

        public static /* synthetic */ ListMarkerInfo copy$default(ListMarkerInfo listMarkerInfo, int n, char c, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = listMarkerInfo.markerLength;
            }
            if ((n3 & 2) != 0) {
                c = listMarkerInfo.markerType;
            }
            if ((n3 & 4) != 0) {
                n2 = listMarkerInfo.markerIndent;
            }
            return listMarkerInfo.copy(n, c, n2);
        }

        @NotNull
        public String toString() {
            return "ListMarkerInfo(markerLength=" + this.markerLength + ", markerType=" + this.markerType + ", markerIndent=" + this.markerIndent + ")";
        }

        public int hashCode() {
            return (this.markerLength * 31 + this.markerType) * 31 + this.markerIndent;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListMarkerInfo)) break block3;
                    ListMarkerInfo listMarkerInfo = (ListMarkerInfo)object;
                    if (!(this.markerLength == listMarkerInfo.markerLength) || !(this.markerType == listMarkerInfo.markerType) || !(this.markerIndent == listMarkerInfo.markerIndent)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$Companion;", "", "()V", "BASE", "Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "getBASE", "()Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "BQ_CHAR", "", "create", "parent", "newIndentDelta", "", "newType", "newExplicit", "", "newOffset", "intellij-markdown"})
    public static final class Companion {
        @NotNull
        public final CommonMarkdownConstraints getBASE() {
            return BASE;
        }

        private final CommonMarkdownConstraints create(CommonMarkdownConstraints parent, int newIndentDelta, char newType, boolean newExplicit, int newOffset) {
            int n = parent.indents.length;
            int[] indents = new int[n + 1];
            char[] types = new char[n + 1];
            boolean[] isExplicit = new boolean[n + 1];
            System.arraycopy(parent.indents, 0, indents, 0, n);
            System.arraycopy(parent.getTypes(), 0, types, 0, n);
            System.arraycopy(parent.isExplicit(), 0, isExplicit, 0, n);
            indents[n] = parent.getIndent() + newIndentDelta;
            types[n] = newType;
            isExplicit[n] = newExplicit;
            return parent.createNewConstraints(indents, types, isExplicit, newOffset);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

