/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.dependency;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.dependency.pattern.PatternType;

public class DownloadableArtifact
implements Serializable {
    String repoUrl;
    String targetDirPath;
    String relativeDirPath;
    String filePath;
    String matrixParameters;
    private PatternType patternType;
    private String sourcePattern;
    private boolean explode;

    public DownloadableArtifact() {
    }

    public DownloadableArtifact(String repoUrl, String targetDirPath, String filePath, String matrixParameters, String sourcePattern, PatternType patternType) {
        this.repoUrl = repoUrl;
        this.targetDirPath = targetDirPath == null ? "" : targetDirPath;
        this.filePath = filePath;
        this.matrixParameters = matrixParameters;
        this.patternType = patternType;
        this.sourcePattern = this.extractRepoFromPattern(sourcePattern);
        this.relativeDirPath = this.calculateRelativeDirFromPattern();
    }

    private String extractRepoFromPattern(String sourcePattern) {
        int indexOfColon = StringUtils.indexOf((String)sourcePattern, (String)":");
        if (indexOfColon == -1) {
            return sourcePattern;
        }
        return StringUtils.substring((String)sourcePattern, (int)(indexOfColon + 1), (int)StringUtils.length((String)sourcePattern));
    }

    private String calculateRelativeDirFromPattern() {
        String rootDirToRemove;
        int lastSlash;
        int firstStar = this.sourcePattern.indexOf(42);
        if (firstStar > 1 && (lastSlash = (rootDirToRemove = this.sourcePattern.substring(0, firstStar)).lastIndexOf(47)) > 1 && this.filePath.startsWith(rootDirToRemove = rootDirToRemove.substring(0, lastSlash + 1))) {
            return this.filePath.substring(rootDirToRemove.length());
        }
        return this.filePath;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public String getTargetDirPath() {
        return this.targetDirPath;
    }

    public void setTargetDirPath(String targetDirPath) {
        this.targetDirPath = targetDirPath;
    }

    public String getRelativeDirPath() {
        return this.relativeDirPath;
    }

    public void setRelativeDirPath(String relativeDirPath) {
        this.relativeDirPath = relativeDirPath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getMatrixParameters() {
        return this.matrixParameters;
    }

    public PatternType getPatternType() {
        return this.patternType;
    }

    public String getSourcePattern() {
        return this.sourcePattern;
    }

    public boolean isExplode() {
        return this.explode;
    }

    public void setExplode(boolean explode) {
        this.explode = explode;
    }
}

